<?PHP
#
#   FILE:  ConfirmDeleteQualifier.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2001-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Confirm Delete Qualifier");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintQualifierNames()
{
    global $Qualifiers;

    foreach ($Qualifiers as $QualifierId)
    {
        $Qualifier = new Qualifier($QualifierId);
        $QualifierName = $Qualifier->Name();
        print $QualifierName."<br>";
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $Qualifiers;

# grab entry information from database
$DB = new Database();

$Qualifiers = $Session->Get("Qualifiers");
$Session->PassVariable("Qualifiers", $Qualifiers);

if (!CheckAuthorization( PRIV_SYSADMIN )) {  return;  }

?>
