<?PHP
#
#   FILE:  DeleteTopicComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

if (!CheckAuthorization( PRIV_SYSADMIN )) {  return;  }

global $AF;

# Be sure that the required parameters were specified:
if (!isset($_POST["F_Submit"]) || !isset($_GET["TI"]) ||
    !isset($_POST["F_OkayToDelete"]) )
{
    $AF->SetJumpToPage("UnauthorizedAccess");
    return;
}

# Pull out the requested topic:
$Topic = new Topic($_GET["TI"]) ;

# If an invalid ID was specified, bounce to Unauthorized:
if ($Topic->GetErrorStatus() != Topic::OK)
{
    $AF->SetJumpToPage("UnauthorizedAccess");
    return;
}

# Otherwise, handle the request:
$F_Submit = $_POST["F_Submit"];
if ($F_Submit == "Delete Topic")
{
    $AF->SetJumpToPage("index.php?P=ForumTopics&FI=".$Topic->ForumId() );
    $Topic->Delete();
}
else
{
    $AF->SetJumpToPage("index.php?P=TopicMessages&TI=".$Topic->TopicId());
}
