<?PHP
#
#   FILE:  EditSysConfig.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Get all of the possible mail templates for saved searches. This includes the
* default template (SearchMailTemplate--{Body,Resource}.txt) and any templates
* from the Mailer plugin.
* @return Returns an array of possible mamil templates for saved searches.
*/
function GetSavedSearchMailTemplates()
{
    $Templates = array(-1 => "Default");

    # only show the default if the Mailer plugin isn't enabled
    if (!$GLOBALS["G_PluginManager"]->PluginEnabled("Mailer"))
    {
        return $Templates;
    }

    # add templates from the Mailer plugin
    $MailerPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("Mailer");
    $Templates += $MailerPlugin->GetTemplateList();

    return $Templates;
}

# functions to return sys config info (for insertion into forms)
function PrintClassificationTypes()
{
    global $G_SysConfig;

    # print option list for UI
    $Schema = new MetadataSchema();
    $FieldNames = $Schema->GetFieldNames(MetadataSchema::MDFTYPE_TREE);

    # transform field names to displayable labels
    foreach ($FieldNames as $Id => $Name)
    {
        $FieldNames[$Id] = $Schema->GetFieldByName($Name)->GetDisplayName();
    }

    # create the option list
    $OptionList = new HtmlOptionList("F_BrowsingFieldId", $FieldNames,
            $G_SysConfig->BrowsingFieldId());

    # print the option list
    $OptionList->PrintHtml();
}

function PrintCheckedWhen($Option, $Value)
{
    global $G_SysConfig;
    if ($G_SysConfig->{$Option}() == $Value){ print("checked"); }
}

function PrintCheckedIf($Option)
{
    global $G_SysConfig;
    if ($G_SysConfig->{$Option}()) {  print("checked");  }
}
function PrintCheckedIfNot($Option)
{
    global $G_SysConfig;
    if (!$G_SysConfig->{$Option}()) {  print("checked");  }
}

function PrintCheckedIfSearchTermHandlingIsAnd()
{
    global $G_SysConfig;
    if ($G_SysConfig->SearchTermsRequired()) {  print("checked");  }
}
function PrintCheckedIfSearchTermHandlingIsOr()
{
    global $G_SysConfig;
    if (!$G_SysConfig->SearchTermsRequired()) {  print("checked");  }
}
function PrintCheckedIfReleaseFlagApproved()
{
    global $G_SysConfig;
    if ($G_SysConfig->ReleaseFlagApproved()) {  print("checked");  }
}
function PrintCheckedIfReleaseFlagNotApproved()
{
    global $G_SysConfig;
    if (!$G_SysConfig->ReleaseFlagApproved()) {  print("checked");  }
}

function PrintGoogleAnalyticsCode()
{
    global $G_SysConfig;
    print($G_SysConfig->GoogleAnalyticsCode());
}

function PrintActiveUIOptionList()
{
    global $G_SysConfig;

    # print option list for UI
    print(GetActiveUIOptionList($G_SysConfig->DefaultActiveUI()));
}

function PrintDefaultNumSearchResultsOptionlist()
{
    global $G_SysConfig;

    $RecordsPerPage = array(
        "5" => 5,
        "10" => 10,
        "20" => 20,
        "30" => 30,
        "50" => 50,
        "100" => 100);

    $OptionList = new HtmlOptionList("F_DefaultRecordsPerPage", $RecordsPerPage,
            $G_SysConfig->DefaultRecordsPerPage());

    $OptionList->PrintHtml();
}

function PrintSiteKeywords()
{
    global $G_SysConfig;

    # print the keywords as stored in the SysConfig object
    print($G_SysConfig->SiteKeywords());
}

/**
 * Print the options for the default privileges of new users.
 */
function PrintDefaultUserPrivsOptionList()
{
    global $G_SysConfig;

    $PrivilegeFactory = new PrivilegeFactory();
    $Privileges = $PrivilegeFactory->GetPrivileges(TRUE, FALSE);

    $OptionList = new HtmlOptionList("F_DefaultUserPrivs[]", $Privileges,
            $G_SysConfig->DefaultUserPrivs());
    $OptionList->MultipleAllowed(TRUE);
    $OptionList->PrintIfEmpty(TRUE);

    $OptionList->PrintHtml();
}

/**
 * Print the options for the default sort field on the advanced search results
 * page.
 */
function PrintDefaultSortFieldOptionList()
{
    global $G_SysConfig, $G_User;

    $Schema = new MetadataSchema();
    $PossibleSortFields = $Schema->GetFields(
        MetadataSchema::MDFTYPE_TEXT |
        MetadataSchema::MDFTYPE_NUMBER |
        MetadataSchema::MDFTYPE_DATE |
        MetadataSchema::MDFTYPE_TIMESTAMP |
        MetadataSchema::MDFTYPE_URL);
    $SelectedSortField = $G_SysConfig->DefaultSortField();

    PrintDefaultSortField(NULL, "Relevance");

    foreach ($PossibleSortFields as $Field)
    {
        $ViewingPrivilege = $Field->ViewingPrivilege();

        if ($Field->IncludeInSortOptions() &&
            (!$ViewingPrivilege || $G_User->HasPriv($ViewingPrivilege)))
        {
            $Selected = $Field->Id() == $SelectedSortField;
            PrintDefaultSortField($Field->Id(), $Field->GetDisplayName(), $Selected);
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function PrintValue($ValueName)
{
    global $G_SysConfig;

    $FormVar = "F_".$ValueName;
    if (isset($_SESSION[$FormVar])) ${$FormVar} = $_SESSION[$FormVar];
    if (isset(${$FormVar}))
    {
        print(htmlspecialchars(StripXSSThreats(${$FormVar})));
        unset($_SESSION[$FormVar]);
    }
    else
    {
        print(htmlspecialchars(StripXSSThreats($G_SysConfig->{$ValueName}())));
    }
}

# ----- MAIN -----------------------------------------------------------------

require_once "lib/AxisPHP/Axis--StandardLibrary.php";

global $G_Schema;

if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

# insure that valid values are available
if ($G_SysConfig->Value("PreferredLinkValue") != "URL")
        {  $G_SysConfig->Value("PreferredLinkValue", "FILE");  }
if ($G_SysConfig->Value("TitlesLinkTo") != "RECORD")
        {  $G_SysConfig->Value("TitlesLinkTo", "URL");  }

$G_Schema = new MetadataSchema();
