<?PHP
#
#   FILE:  PreviewComment.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2016 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Preview Comment");


$ResourceId = GetFormValue("RI");
if ($ResourceId === NULL)
{
    $H_ErrorMessages[] = "No ResourceId specified.";
    return;
}
elseif (!Resource::ItemExists($ResourceId))
{
    $H_ErrorMessages[] = "Nonexistent resource requested.";
    return;
}
elseif (!isset($_SESSION["Body"]))
{
    $H_ErrorMessages[] = "No message body provided for preview.";
    return;
}
else
{
    $H_Body = $_SESSION["Body"];
    unset ($_SESSION["Body"]);
}

if (isset($_GET["MI"]))
{
    $H_MessageId = intval($_GET["MI"]);
}

$H_Resource = new Resource($ResourceId);
