<?PHP
#
#   FILE:  SavedSearch.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Print saved searches.
*/
function PrintSavedSearches()
{
    global $SysConfig;
    global $User;

    $SSFactory = new SavedSearchFactory();
    $Searches = $SSFactory->GetSearchesForUser($User->Id());
    $NumColumns = $SysConfig->UserAgentsEnabled() ? 5 : 4;

    if ($User->HasPriv(PRIV_RESOURCEADMIN))
    {
        $FreqList = SavedSearch::GetSearchFrequencyList();
    }
    else
    {
        $FreqList = SavedSearch::GetSearchFrequencyList(SavedSearch::SEARCHFREQ_HOURLY);
    }

    # if no saved searches found
    if (count($Searches) < 1)
    {
        # add message indicating no saved searches
        // @codingStandardsIgnoreStart
        ?>
        <tr>
            <td colspan="<?PHP print $NumColumns; ?>">
                There are no searches currently saved.
                You can enter and save a search via the
                <a href="index.php?P=AdvancedSearch">Advanced Search</a> page.
            </td>
        </tr>
        <?PHP
        // @codingStandardsIgnoreEnd
    }
    else
    {
        # add table row for each saved search
        foreach ($Searches as $SearchId => $Search)
        {
            $DisplayParams = SPTSearchEngine::ConvertToDisplayParameters(
                $Search->SearchParameters() );
            // @codingStandardsIgnoreStart
            ?>
            <tr>
                <th><a href="index.php?P=SearchResults&amp;<?PHP
                   print $Search->SearchParameters()->UrlParameterString();?>"
                ><?PHP  print($Search->SearchName());  ?></a></th>
                <td>
                <a class="cw-button cw-button-elegant cw-button-constrained"
                    href="index.php?P=AdvancedSearch&amp;ID=<?PHP
                   print($SearchId);  ?>">Edit</a>
                </td>
                <td>
                <a class="cw-button cw-button-elegant cw-button-constrained"
                    href="index.php?P=SavedSearch&amp;AC=Delete&amp;SI=<?PHP
                         print($SearchId);  ?>">Delete</a>
                </td>

                <?PHP  if ($SysConfig->UserAgentsEnabled()) {  ?>
                <td><?PHP
                   $OptionList = new HtmlOptionList(
                           "F_Frequency_".$SearchId, $FreqList, $Search->Frequency());
                   $OptionList->SubmitOnChange(TRUE);
                   $OptionList->PrintHtml();
                ?></td>
                <?PHP  }  ?>
                <td><?PHP print($DisplayParams->TextDescription(TRUE, FALSE));  ?></td>
            </tr>
        <?PHP
        // @codingStandardsIgnoreEnd
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

include_once "lib/AxisPHP/Axis--StandardLibrary.php";  # (for PrintOptionList())

if (!CheckAuthorization()) {  return;  }
PageTitle("Manage Saved Searches");

# if user asked to save new search
if (isset($_POST["Submit"]) && $_POST["Submit"] == "Save")
{
    # if reasonable search name was supplied
    if (isset($_POST["F_SearchName"]) && strlen(trim($_POST["F_SearchName"])))
    {
        $FreqList = SavedSearch::GetSearchFrequencyList();
        $F_SearchFreq = isset($_POST["F_SearchFreq"])
            ? intval($_POST["F_SearchFreq"]) : NULL;
        $Frequency = isset($FreqList[$F_SearchFreq])
            ? $F_SearchFreq : SavedSearch::SEARCHFREQ_NEVER;

        $SearchParams = new SearchParameterSet();
        $SearchParams->UrlParameters($_GET);

        # save search
        $NewSavedSearch = new SavedSearch(
            NULL, $_POST["F_SearchName"],
            $User->Id(), $Frequency, $SearchParams);
    }
    else
    {
        # set error message and return back to new saved search page
        $_SESSION["ErrorMessage"] = "ERROR: No name was supplied for the saved search.";
        $SearchParams = new SearchParameterSet();
        $SearchParams->UrlParameters($_GET);
        $AF->SetJumpToPage("NewSavedSearch&".$SearchParams->UrlParameterString());
        return;
    }
}

# else if user asked to delete search
elseif (isset($_GET["AC"]) && ($_GET["AC"] == "Delete"))
{
    # delete specified search
    $Search = new SavedSearch($_GET["SI"]);
    $Search->Delete();
}

# else if user asked to change search frequency
elseif (isset($_POST["AC"]) && ($_POST["AC"] == "ChangeFrequency"))
{
    # for each saved search
    $SSFactory = new SavedSearchFactory();
    $Searches = $SSFactory->GetSearchesForUser($User->Id());
    foreach ($Searches as $Search)
    {
        # if frequency has changed
        if (isset($_POST["F_Frequency_".$Search->GetSearchId()]) &&
                ($_POST["F_Frequency_".$Search->GetSearchId()] != $Search->Frequency()))
        {
            # update frequency
            $Search->Frequency($_POST["F_Frequency_".$Search->GetSearchId()]);
        }
    }
}
