<?PHP
#
#   FILE:  EditBlog.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

CheckAuthorization(PRIV_SYSADMIN);

$BlogPlugin = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();

# pull out the requested settings, if they exist or a template otherwise
if ($_GET["BI"] == "NEW")
{
    $H_BlogId = "NEW";
    $MySettings = $BlogPlugin->GetBlogConfigTemplate();
}
else
{
    $H_BlogId = intval($_GET["BI"]);
    $MySettings = $BlogPlugin->BlogSettings($H_BlogId);
}

# generate a ConfigSettingsUI
$H_ConfigUI = new ConfigSettingsUI(
    $BlogPlugin->GetBlogConfigOptions(), $MySettings );
