<?PHP
#
#   FILE:  Subscribe.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

# make sure our plugin is enabled, bounce to Home if not
if (!$GLOBALS["G_PluginManager"]->PluginEnabled("MailingList"))
{
    $GLOBALS["AF"]->SetJumpToPage("Home");
    return;
}

$Jump = GetArrayValue($_GET, "ReturnTo", "Preferences");
$H_List = GetArrayValue($_GET, "List", NULL);

if ($GLOBALS["G_User"]->IsLoggedIn())
{
    $GLOBALS["AF"]->SuppressHTMLOutput();

    if ($H_List !== NULL)
    {
        $MyPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("MailingList");
        $MyPlugin->Subscribe( $GLOBALS["G_User"], $H_List );
    }

    $GLOBALS["AF"]->SetJumpToPage($Jump);
}
else
{
    $EmailAddr = isset($_GET["F_EMail"]) ?
               $_GET["F_EMail"] : "";

    $AdditionalErrorMessages =
            UserEditingUI::GetAdditionalErrorCodes($EmailAddr);

    # set up friendly error messages for the incoming form
    $AdditionalErrorMessages["E_NO_SUCH_LIST"]
        = "No such mailing list";
    $AdditionalErrorMessages["E_NO_LIST_SPECIFIED"]
        = "No mailing list provided" ;

    # modify the DUPLICATEEMAIL error message to be more clear about how
    # subscriptions are edited for existing accounts

    $AdditionalErrorMessages[U_DUPLICATEEMAIL]
        = "The email address you entered is already associated"
        ." with an account.  To manage subscription settings for "
        ." an existing account, you must log in and access your Preferences. "
        ."If you have forgotten the account user name or"
        ." password you can click"
        ." <a href=\"index.php?P=ForgottenPasswordComplete&UN="
        .urlencode($EmailAddr)."\">here</a>"
        ." to send a reminder via email." ;

    $AdditionalErrorMessages =
        $GLOBALS["AF"]->SignalEvent(
            "EVENT_USER_SIGNUP_EXTEND_ERROR_LIST",
                array($AdditionalErrorMessages));

    $H_FTool = new FormTool(
        MailingList::GetSubscriptionFormFields(),
        array_shift($AdditionalErrorMessages));
    $H_FTool->SetFieldValuesFromUrlParams();
}
