<?PHP
#
#   FILE: EditFeed.php (RSSExport plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Edward Almasy and Internet Scout
#   http://scout.wisc.edu/cwis
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Prints the a given setting for a feed. If the feed was being edited and
* the setting is saved as a session variable, it prints that. Otherwise, it
* prints the saved setting. If the setting is a binary setting, it prints
* checked="checked" to select the appropriate radio button.
* @param object $Feed The Feed object to get the setting of.
* @param string $Setting The name of the setting to retrieve.
* @param bool TRUE if the radio button is for the TRUE setting, FALSE if it is
*       for the FALSE setting.  (OPTIONAL)
*/
function PrintSetting($Feed, $Setting, $Checked = NULL)
{
    // get the value from the session if there is one
    $SessionVar = GetArrayValue($_SESSION, $Setting);

    // use the session variable if we have it
    if (isset($SessionVar))
    {
        // remove the session variable
        unset($_SESSION[$Setting]);

        // check the appropriate radio button
        if ($Checked !== NULL)

        {
            if (($Checked && $SessionVar) || (!$Checked && !$SessionVar))
            {
                print " checked=\"checked\"";
            }
        }
        // print the value
        else
        {
            print defaulthtmlspecialchars($SessionVar);
        }
    }
    // if the session variable is not set, try to get the saved variable
    else if (isset($Feed) && get_class($Feed) === "RSSExport_Feed")
    {
        // get the value from the database
        $FeedVar = call_user_func(array($Feed, $Setting));
    }
    // at the very least, make sure to use the default values
    else
    {
        switch ($Setting)
        {
            case "ShowResourceImages":
                $FeedVar = RSSExport::DEFAULT_SHOWRESOURCEIMAGES;
                break;
            case "NotifyBrowser":
                $FeedVar = RSSExport::DEFAULT_NOTIFYBROWSER;
                break;
            case "Comments":
                $FeedVar = RSSExport::DEFAULT_COMMENTS;
                break;
            case "NumItems":
                $FeedVar = RSSExport::DEFAULT_NUMITEMS;
                break;
        }
    }

    // if we have a variable, print it
    if (isset($FeedVar))
    {
        // check the appropriate radio button
        if ($Checked !== NULL)
        {
            if (($FeedVar && $Checked) || (!$FeedVar && !$Checked))
            {
                print " checked=\"checked\"";
            }
        }
        // print the value
        else
        {
            print defaulthtmlspecialchars($FeedVar);
        }
    }
}

/**
* Prints the option elements for a select element containing metadata fields.
* If a feed and a setting are passed in, the funciton will make that metadata
* field selected.
* @param enum $Types The types of fields to use as options ORed together.
*       If not passed in, all types will be chosen.  (OPIONAL)
* @param object $Feed The feed being modified.  (OPTIONAL)
* @param int $Setting The setting to be selected by default.  (OPTIONAL)
*/
function PrintFieldOptions($Types = NULL, $Feed = NULL, $Setting = NULL)
{
    # get every schema
    $Schemas = MetadataSchema::GetAllSchemas();

    # print the null option
    print "<option value=\"\">--</option>\n";

    # using all the schemas
    foreach ($Schemas as $Schema)
    {
        $Fields = $Schema->GetFields($Types);
        foreach ($Fields as $Id => $Field)
        {
            $Selected = "";
            if (isset($_SESSION[$Setting]) && intval($_SESSION[$Setting]) == $Id)
            {
                unset($_SESSION[$Setting]);
                $Selected = " selected=\"selected\"";
            }
            else if (isset($Feed) && get_class($Feed) == "RSSExport_Feed"
                    && call_user_func(array($Feed, $Setting)) == $Id)
            {
                $Selected = " selected=\"selected\"";
            }
            print "<option value=\"" . $Id . "\"" . $Selected . ">"
                    . $Field->Name() . " (" . $Schema->Name() . ")"
                    . "</option>\n";
        }
    }

}

# ----- MAIN -----------------------------------------------------------------

global $AF, $G_PluginManager;

# check authorization
if (!CheckAuthorization( PRIV_SYSADMIN )) { return; }

# establish the feed we're editing
$H_FeedId = GetArrayValue($_GET, "ID", -1);
if ($H_FeedId != "NEW") $H_FeedId = intval($H_FeedId);
$H_Feed = NULL;

# bail out if we don't have an ID
if ($H_FeedId === -1)
{
    $AF->SetJumpToPage("P_RSSExport_ListFeeds");
    return;
}

# get a copy of the plugin
$Plugin = $G_PluginManager->GetPlugin("RSSExport");

# get the available feeds
$H_Feeds = $Plugin->GetFeeds();

# handle the case where the feed does not exist
if (!array_key_exists($H_FeedId, $H_Feeds) && $H_FeedId !== "NEW")
{
    $AF->SetJumpToPage("P_RSSExport_ListFeeds");
    return;
}
# otherwise get the desired feed
else if ($H_FeedId != "NEW")
{
    $H_Feed = $H_Feeds[$H_FeedId];
}

