<?PHP
#
#   FILE:  UrlChecker_Constraint.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2002-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Encapsulate a constraint tuple, which consists of a key, a relation, and a
* value.
*/
class UrlChecker_Constraint
{

    /**
    * Object constructor. Encapsulate the key, value, and relation of the
    * constraint.
    * @param mixed $Key Key to provide context for the constraint.
    * @param mixed $Value Value used to determine if the constraint is met.
    * @param mixed $Relation Relation between the key and value.
    */
    public function __construct($Key=NULL, $Value=NULL, $Relation=NULL)
    {
        $this->Key = $Key;
        $this->Value = $Value;
        $this->Relation = $Relation;
    }

    public $Key;
    public $Value;
    public $Relation;

}
