<?PHP
#
#   FILE:  ConfirmAutofix.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

PageTitle("Confirm an automatic fix to the URL");
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$ResourceId = GetFormValue("ResourceId");
$FieldId = GetFormValue("FieldId");
$Schema = new MetadataSchema();
$Field = $Schema->GetField($FieldId);
$TitleField = $Schema->GetFieldByMappedName("Title");

if (Resource::ItemExists($ResourceId)
        && $Field->Status() == MetadataSchema::MDFSTAT_OK)
{
    $Resource = new Resource($ResourceId);
    $InvalidUrl = $AF->SignalEvent("URLCHECKER_GET_INVALID_URL",
            array($Resource, $Field));
}

else
{
    $AF->SuppressHTMLOutput();
    $AF->SetJumpToPage("index.php?P=P_UrlChecker_Results");
}
