<?PHP
#
#   FILE:  ConfigureActions.php
#
#   Copyright 2014 Internet Scout Project
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

$MyPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("UrlChecker");

# configuration for URL Checker Actions
$H_Schemas = array();
foreach ($MyPlugin->ConfigSetting("FieldsToCheck") as $FieldId)
{
    $Field = new MetadataField($FieldId);
    $SCId = $Field->SchemaId();

    $H_Schemas[$SCId] = new MetadataSchema($SCId);
}

$H_ActionUIs = array();
$Actions = array("Release", "Withhold", "Autofix");
foreach ($Actions as $Action)
{
    $H_ActionUIs[$Action] = array();

    $Configuration = $MyPlugin->ConfigSetting($Action."Configuration");
    foreach ($H_Schemas as $SchemaId => $Schema)
    {
        $H_ActionUIs[$Action][$SchemaId] = new FieldEditingUI($Action."_".$SchemaId, $SchemaId);
        if (isset($Configuration[$SchemaId]))
        {
            $H_ActionUIs[$Action][$SchemaId]->LoadConfiguration($Configuration[$SchemaId]);
        }
        $H_ActionUIs[$Action][$SchemaId]->AddFieldButton();
    }
}