<?PHP
#
#   FILE:  FullImage.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2003-2016 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# retrieve image ID
$ImageId = GetFormValue("ID");

# check that image exists
$H_Image = new SPTImage($ImageId);
if (($ImageId === NULL) || ($H_Image->Status() != AI_OKAY))
{
    $AF->SetJumpToPage("UnauthorizedAccess");
    return;
}

# check that resource associated with image exists
$ResourceId = $H_Image->ResourceId();
$FieldId = $H_Image->FieldId();
if (!Resource::ItemExists($ResourceId))
{
    $AF->SetJumpToPage("UnauthorizedAccess");
    return;
}

# check that user can view image
$H_Resource = new Resource($ResourceId);
if (!$H_Resource->UserCanViewField($GLOBALS["G_User"], $FieldId))
{
    $AF->SetJumpToPage("UnauthorizedAccess");
    return;
}

# load metadata field for image
$H_Field = new MetadataField($FieldId);

