<?PHP

/**
 * Class used to add additional functionality to the Folder class.
 */
class Folders_Folder extends Folder
{
    /**
    * Get sharing (viewing) URL for folder.  A clean URL will be returned if
    * support for them is available.
    * @return string URL for viewing folder.
    */
    public function GetSharingUrl()
    {
        # if clean URL support is available
        if ($GLOBALS["AF"]->HtaccessSupport())
        {
            # assemble clean URL
            $Url = OurBaseUrl()."folders/".sprintf("%04d", $this->Id())
                    ."/".$this->NormalizedName();
        }
        else
        {
            # assemble regular URL
            $Url = OurUrl()."?P=P_Folders_ViewFolder&FolderId=".$this->Id();
        }

        # return assembled URL to caller
        return $Url;
    }
}
