<?php

#
#   FILE:  SPT--UserLogin.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--SPTEventLog.php");
if (file_exists("include/SPT--Local.php")) {  require_once("include/SPT--Local.php");  }


# try to log user in
$LoginResult = NULL;
if (isset($_POST["F_UserName"]) && isset($_POST["F_Password"]))
{
    $LoginResult = $G_User->Login($_POST["F_UserName"],
                    $_POST["F_Password"]);
}

# if login was successful
if ($LoginResult == U_OKAY)
{
    # is user account disabled?
    if ($G_User->HasPriv(PRIV_USERDISABLED))
    {
        # log user out
        $G_User->Logout();
        PrintAutoRefreshPage("Login Error", "SPT--LoginError.php");
        exit;
    }
    else
    {
        # record successful login event
        $EventLog = new SPTEventLog();
        $EventLog->Log(SPTEVENT_USERLOGIN, $_SERVER["REMOTE_ADDR"]);

        # list of pages we do not want to return to
        $DoNotReturnToPages = array(
                "SPT--Login.php",
                "SPT--LoginError.php",
                "SPT--ForgottenPasswordComplete.php",
                "SPT--RequestAccount.php",
                "SPT--RequestAccountComplete.php",
                "SPT--ActivateAccount.php",
                "SPT--ResendAccountActivation.php",
                "SPT--ResetPassword.php",
                "SPT--ForgottenPasswordComplete.php",
                );

        # add in any locally-defined pages not to return to
        if (function_exists("Local_GetDoNotReturnToPages"))
        {
            $DoNotReturnToPages = array_merge($DoNotReturnToPages,
                    Local_GetDoNotReturnToPages());
        }

        # if originating page looks like a valid destination
        $OrigPage = $_SERVER["HTTP_REFERER"];
        $OrigPagePieces = explode("?", basename($OrigPage));
        $OrigPageFile = array_shift($OrigPagePieces);
        if (!in_array($OrigPageFile, $DoNotReturnToPages))
        {
            # head to originating page
            PrintAutoRefreshPage("User Logged In", $OrigPage);
        }
        else
        {
            # head to home page
            PrintAutoRefreshPage("User Logged In", "SPT--Home.php");
        }
    }
}
else
{
    # go to login error page
    PrintAutoRefreshPage("Login Error", "SPT--LoginError.php");
}

?>
