<?PHP

#
#   FILE:  SPT--DBOrderFields.php
#
#   FUNCTIONS PROVIDED:
#       PrintOrderedDisplayFields()
#           - Prints option elements for Enabled and Viewable fields in 
#            Display order. Calls PrintDisplayFieldName()
#       PrintOrderedEditingFields()
#           - Prints option elements for Enabled and Viewable fields in 
#            Editing order. Calls PrintEditingFieldName()
#       PrintOrderedLabel()
#           - Prints label for field
#       PrintOrderedFieldId()
#           - Prints Id of field
#
#   FUNCTIONS EXPECTED:
#       PrintDisplayFieldName()
#           - Print option field in display order
#       PrintEditingFieldName()
#           - Print option field in editing order
#
#   FORM FIELDS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--MetadataSchema.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# PrintOrderedDisplayFields prints fields names in Display order.
function PrintOrderedDisplayFields()
{
    PrintOrderedFields( MDFORDER_DISPLAY );    
}

# PrintOrderedEditingFields prints fields names in Editing order.
function PrintOrderedEditingFields()
{
    PrintOrderedFields( MDFORDER_EDITING );    
}

# function to print field name 
function PrintLabel()
{
    global $Label;

    print $Label;
}

# function to print field Id 
function PrintFieldId()
{
    global $FieldId;

    print $FieldId;
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

function PrintOrderedFields( $Order )
{
    global $Label;
    global $FieldId;

    # Initialize the schema object
    $Schema = & new MetadataSchema();

    # Get fields, order indicated by $Order
    $Fields = $Schema->GetFields(NULL, $Order, FALSE);

    # Grab the fields that are enabled.
    # Fields for Display must be Viewable
    foreach ($Fields as $Field)
    {
        if ($Field->Enabled())
        {
            $Labels[] = $Field->Name();
        }
    }

    # Get the relevant information from the Field object and display it
    foreach ($Labels as $Label)
    {
        $Field = $Schema->GetFieldByName($Label);
        $FieldId = $Field->Id();
        
        #Call to function in html page
        if ( $Order == MDFORDER_DISPLAY )
        {
            PrintDisplayFieldName();
        }
        else
        {
            PrintEditingFieldName();
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

PageTitle("Metadata Field Ordering");
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

include("include/SPT--StandardHtmlPageLoad.php");

?>
