<?php

#
#   FILE:  SPT--RequestAccount.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2006 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--FormTool.php");
PageTitle("New User Sign-Up");

# set up expectations for incoming form
require_once("include/SPT--Form--RequestAccount.php");
$AdditionalErrorMessages = array(
        U_PASSWORDSDONTMATCH   => "The two passwords you entered did not match.",
        U_EMAILSDONTMATCH   => "The two e-mail addresses you entered did not match.",
        U_DUPLICATEUSERNAME => "The user name you entered is already in use.",
        U_ILLEGALUSERNAME   => "The user name you entered is not valid."
                ." User names must be made up of one word containing between 2 and 24"
                ." letters and/or numbers.",
        U_MAILINGERROR      => "An error was encountered trying to send an"
                ." e-mail message to activate your new account.  Please contact the"
                ." administrator of this site and inform them of the problem.",
        U_EMPTYPASSWORD => "Please enter a password at least 6 characters long"
                ." into both password fields below.",
        U_EMPTYPASSWORDAGAIN => "Please enter a password at least 6 characters long"
                ." into both password fields below.",
        U_ILLEGALPASSWORD => "Please enter a password at least 6 characters long"
                ." into both password fields below.",
        U_ILLEGALPASSWORDAGAIN => "Please enter a password at least 6 characters long"
                ." into both password fields below.",
        U_DUPLICATEEMAIL => "The e-mail address you entered is already associated"
                ." with an account.  If you have forgotten the account user name or"
                ." password you can click"
                ." <a href=\"SPT--ForgottenPasswordComplete?UN="
                        .(isset($_GET["F_EMail"]) ? $_GET["F_EMail"] : "")
                        ."\">here</a>"
                ." to send a reminder via e-mail.",
        );
$FTool = new FormTool($FormFields, $AdditionalErrorMessages);
$FTool->SetFieldValuesFromUrlParams();

include("include/SPT--StandardHtmlPageLoad.php");


?>
