CREATE TABLE UserSearch (
    UserId              INT NOT NULL,
    SearchId            SMALLINT NOT NULL AUTO_INCREMENT,
    SearchName          TEXT,
    SearchCat1          TEXT,
    SearchText1         TEXT,
    SearchCat2          TEXT,
    SearchText2         TEXT,
    SearchCat3          TEXT,
    SearchText3         TEXT,
    SearchCat4          TEXT,
    SearchText4         TEXT,
    DomainLimit         TEXT,
    DateLimit           TEXT,
    ResourceType        int,
    Language            int,
    Audience            int,
    Format              int,
    Display             TEXT,
    MaxRecords          TEXT,
    Frequency           TEXT,
    DateLastRun         TIMESTAMP (14),
    INDEX               (UserId),
    INDEX               (SearchId)
);

CREATE TABLE RSSConfiguration(
    EntriesToPublish        INT,
    ChannelTitle            TEXT,
    ChannelDescription      TEXT,
    ImageUrl                TEXT,
    ImageTitle              TEXT,
    ImageLink               TEXT,
    ImageHeight             INT,
    ImageWidth              INT,
    ImageDescription        TEXT,
    Language                TEXT,
    Copyright               TEXT,
    ManagingEditor          TEXT,
    Webmaster               TEXT,
    PicsRating              TEXT
);

# set up default RSS Export configuration options
INSERT INTO RSSConfiguration (EntriesToPublish, ChannelTitle,
            ChannelDescription, ImageUrl, ImageTitle, ImageLink, 
            ImageHeight, ImageWidth, ImageDescription, Language, Copyright, 
            ManagingEditor, Webmaster, PicsRating)
        VALUES(15, 'Scout Portal Toolkit',
            'Channel Description', 'Image Url', 'Image Title', 'Image Link', 
            0, 0, 'Image Description', 'en-us', 'Copyright 2002',  
            'Managing Editor', 'Webmaster', '');

ALTER TABLE SystemConfiguration ADD COLUMN SearchTermsRequired INT;
ALTER TABLE SystemConfiguration ADD COLUMN UserAgentsEnabled INT DEFAULT 0;
UPDATE SystemConfiguration SET SearchTermsRequired = 1;

ALTER TABLE ResourceRatings ADD COLUMN Rating INT;
ALTER TABLE ResourceRatings ADD COLUMN CommentApproved INT;
ALTER TABLE Resources ADD COLUMN CumulativeRating INT;

ALTER TABLE SearchFields ADD COLUMN FieldLocation INT;
DELETE FROM SearchFields;

