
ALTER TABLE UserSearch ADD COLUMN LastModifiedBy text;
ALTER TABLE SystemConfiguration ADD COLUMN AnnouncementsEnabled INT DEFAULT 1;
ALTER TABLE SystemConfiguration ADD COLUMN ForumsEnabled INT DEFAULT 1;
ALTER TABLE SystemConfiguration ADD COLUMN AllowMultipleUIsEnabled INT DEFAULT 1;
ALTER TABLE SystemConfiguration ADD COLUMN ResourceLaunchesNewWindowEnabled INT DEFAULT 1;

-- make ID fields no longer auto-increment to work with new ItemFactory
ALTER TABLE Resources CHANGE COLUMN ResourceId ResourceId INT NOT NULL;
ALTER TABLE MetadataFields CHANGE COLUMN FieldId FieldId INT NOT NULL;

-- add image info table
CREATE TABLE Images (
    ImageId                 INT NOT NULL,
    Format                  INT,
    AltText                 TEXT,
    Width                   INT,
    Height                  INT,
    PreviewWidth            INT,
    PreviewHeight           INT,
    ThumbnailWidth          INT,
    ThumbnailHeight         INT,
    INDEX                   (ImageId)   
);  

-- add fields to support qualifiers
ALTER TABLE ControlledNames ADD COLUMN QualifierId INT;
ALTER TABLE Classifications ADD COLUMN QualifierId INT;
ALTER TABLE MetadataFields ADD COLUMN UsesQualifiers INT DEFAULT 0;
ALTER TABLE MetadataFields ADD COLUMN HasItemLevelQualifiers INT DEFAULT 0;
ALTER TABLE MetadataFields ADD COLUMN DefaultQualifier INT;

-- add tables to support qualifiers
CREATE TABLE Qualifiers (
    QualifierId            INT NOT NULL,
    QualifierName          TEXT,
    QualifierNamespace     TEXT,
    QualifierUrl           TEXT,
    INDEX                  (QualifierId)
);
CREATE TABLE FieldQualifierInts (
    MetadataFieldId        INT NOT NULL,
    QualifierId            INT NOT NULL,
    INDEX                  (MetadataFieldId, QualifierId)
);

-- add fields to support temp MetadataField records
ALTER TABLE MetadataFields ADD COLUMN DateLastModified TIMESTAMP;
ALTER TABLE MetadataFields ADD COLUMN LastModifiedById INT;

