/*
#
# JavaScript to create an image preview.
# 
# At the very least, the trigger has to have its class set to 
# "ImagePreview" and a "previewsrc" attribute set to the image
# source of the preview image. Additional attributes for the
# preview image can also be set (id, height, width, style, alt)
# by setting a "preview*" attribute, where * is the attribute to
# set. Functionality to include text, etc in the preview is not
# yet included, but would be easy to implement if needed.
#
*/

    // Set the variables needed
    var PreviewClass    = "ImagePreview";    // The class of elements for the EIP functionality
    var TriggerElement  = "TriggerElement";  // The id of the trigger element
    var HeaderElement   = "EIPHeader";       // The id of the header element
    var InputElement    = "EIPInput";        // The id of the input(s) element
    var CButtonElement  = "EIPCustomButton"; // The id of the custom button element
    var ButtonElement   = "EIPButtons";      // The id of the button(s) element
    var TextareaElement = "EIPText";         // The id of the textarea element
    var EditDivClass    = "EditDiv";         // The class of the editing layer
    var EditDivId       = "IP_Previewer";    // The id of the editing layer
    var PointerLocation = "SPTUI--CWIS/images/edit_triangle.gif";
    var ImageToPreview  = "ImageToPreview";  // Class of the image to preview
    // The text of the edit div
    var EditDivText     = "<div class='"+HeaderElement+"' id='"+HeaderElement+"' style='background:#D2DADA;'></div>" +
                          "<div style='position: absolute;'><img src="+PointerLocation+" style='position:relative;top:75px;right:19px;_right:29' /></div>" +
                          "<div class='"+InputElement+"' style='background: #D2DADA;'>" +
                          "<img class="+ImageToPreview+" src='' /></div>" +
                          "<div class='"+ButtonElement+"' id='"+ButtonElement+"'></div>";

    // Create the image preview layer, set its attr., and append it to the body
    var PreviewLayer = document.createElement("div");
    PreviewLayer.innerHTML   = EditDivText;
    PreviewLayer.className   = EditDivClass;
    PreviewLayer.id          = EditDivId;
    PreviewLayer.style.width = "auto";
    document.body.appendChild(PreviewLayer);
    
    $(document).ready(function(){
        $("img."+PreviewClass).mouseover(function(){
            // Set the image attributes
            $("img."+ImageToPreview, "div#"+EditDivId).attr({
               id: $(this).attr("previewid"),
               src: $(this).attr("previewsrc"),
               height: $(this).attr("previewheight"),
               width: $(this).attr("previewwidth"),
               style: $(this).attr("previewstyle"),
               alt: $(this).attr("alt")
            });
           
            // Get necessary position/size numbers
            var ThumbnailSize = GetElementSize($(this).get(0));
            var ThumbnailPosition = GetElementPosition($(this).get(0));
            var TrianglePosition = 75;
            var PreviewPosition = {Left:(ThumbnailPosition.Left + ThumbnailSize.Width + 25),
                    Top:(ThumbnailPosition.Top + (ThumbnailSize.Height / 2) - TrianglePosition - 25)};
           
            // Correctly position the preview div
            $("div#"+EditDivId).css({
                top: PreviewPosition.Top,
                left: PreviewPosition.Left
            });
           
            // Display the image preview div
            $("div#"+EditDivId).fadeIn(100);
       });
        
       $("img."+PreviewClass).mouseout(function(){
            $("div#"+EditDivId).fadeOut(100);
       });
   });