<?PHP
#
#   FILE:  ListEntries.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

PageTitle("Blog Entries");

$H_Blog = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();
$H_Schema = new MetadataSchema($H_Blog->GetSchemaId());

# don't allow unauthorized access
if (!$H_Schema->UserCanEdit($GLOBALS["G_User"]))
{
    CheckAuthorization(FALSE);
    return;
}

$H_BlogId = array_key_exists("BlogId", $_GET) ?
    intval($_GET["BlogId"]) :
    current(array_keys($H_Blog->GetAvailableBlogs())) ;

$H_Blog->SetCurrentBlog($H_BlogId);


$ModificationField = $H_Schema->GetFieldByName(Blog::MODIFICATION_DATE_FIELD_NAME);
$DBFieldName = $ModificationField->DBFieldName();

# set up some basic values
$H_SortField = GetFormValue("SF", $DBFieldName);
$H_SortAscending = GetFormValue("SA", 0);
$H_StartingIndex = GetFormValue("SI", 0);
$H_EntriesPerPage = 25;
$H_SchemaId = $H_Blog->GetSchemaId();
$H_Entries = array();


# get the blog entries
$Factory = new Blog_EntryFactory($H_BlogId);
$EntryIds = $Factory->GetItemIds(NULL, FALSE, $H_SortField, $H_SortAscending);
$H_EntryCount = count($EntryIds);

# calculate ID array checksum and reset paging if list has changed
$H_ListChecksum = md5(serialize($EntryIds));
if ($H_ListChecksum != GetFormValue("CK")) {  $H_StartingIndex = 0;  }

# prune entry IDs down to just currently-selected segment
$EntryIds = array_slice($EntryIds, $H_StartingIndex, $H_EntriesPerPage);

# load blog entries from IDs
foreach ($EntryIds as $Id)
{
    $H_Entries[$Id] = new Blog_Entry($Id);
}
