<?PHP
#
#   FILE:  ConfirmRemoveUser.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
* Get the forums whose moderator is one of the users that is being deleted.
* This function returns an array of forum information of such forums.
* @param array $UserRemoveArray Array of users scheduled for deletion.
* @return An array of forum information with the following as key:
*       Id, Name, Description.
*/
function GetAssociatedForums($UserRemoveArray)
{
    $Forums = array();
    $DB = new Database();
    foreach ($UserRemoveArray as $UserId)
    {
        $DB->Query("SELECT ForumId FROM Forums WHERE ModeratorId = ".$UserId);
        while ($Row = $DB->FetchRow())
        {
            # create forum to collect forum info
            $ForumId = $Row["ForumId"];
            $Forum = new Forum($ForumId);

            # put info in array to return
            $ForumInfo["Id"] = $ForumId;
            $ForumInfo["Name"] = $Forum->ForumName();
            $ForumInfo["Description"] = $Forum->ForumDescription();

            $Forums[] = $ForumInfo;
        }
    }

    return $Forums;
}

# ----- MAIN -----------------------------------------------------------------

PageTitle("Confirm Remove User");

# check if current user is authorized
CheckAuthorization(PRIV_USERADMIN, PRIV_SYSADMIN);

# get the list of users to remove
$H_UsersToRemove = GetArrayValue($_SESSION, "UserRemoveArray", array() );

# check if the user is trying to remove his or her own account
$OwnIdKey = array_search($GLOBALS["User"]->Id(), $H_UsersToRemove);
$H_TriedRemovingOwnAccount = FALSE;

# the user tried to remove his or her own account, so don't allow it
if ($OwnIdKey !== FALSE)
{
    $H_TriedRemovingOwnAccount = TRUE;
    unset($H_UsersToRemove[$OwnIdKey]);
}

# check if any of these accounts owns a forums
$H_AssociatedForums = GetAssociatedForums($H_UsersToRemove);

# pass along the values to the removal page
$_SESSION["OkayToRemoveUsers"] = 1;
$_SESSION["UserRemoveArray"] = $H_UsersToRemove ;
