<?PHP
#
#   FILE:  EditTopic.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Edit Topic");

# get parameters or set error messages to display (if authorized)
if (!isset($_GET["TI"]))
{
    $H_ErrorMessages[]= "No TopicId Specified";
}
else
{
    if (Topic::ItemExists(intval($_GET["TI"])))
    {
        $H_Topic = new Topic(intval($_GET["TI"]));
        $ForumModerator = (new Forum($H_Topic->ForumId()))->ModeratorId();
    }
    else
    {
        $H_ErrorMessages[]= "Invalid TopicId Specified";
    }
}

# check if the current user is authorized, if not, abort
if (isset($ForumModerator))
{
    if ($GLOBALS["G_User"]->Id() != $ForumModerator && !CheckAuthorization(PRIV_SYSADMIN))
    {
        DisplayUnauthorizedAccessPage();
        return;
    }
}
else if (!CheckAuthorization(PRIV_SYSADMIN))
{
    return;
}
