<?PHP
#
#   FILE:  DeleteFeed.php (RSSImport plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2017 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis
#

# make sure user has privileges to delete feed
CheckAuthorization(PRIV_SYSADMIN);

# if feed was not specified
$FeedFactory = new RSSImport_FeedFactory();
if (!isset($_GET["ID"]))
{
    # set error display
    $H_DisplayMode = "NoFeedSpecified";
}
# else if specified feed does not exist
elseif (!$FeedFactory->ItemExists($_GET["ID"]))
{
    # set error display
    $H_DisplayMode = "FeedDoesNotExist";
}
else
{
    # load feed
    $H_Feed = new RSSImport_Feed($_GET["ID"]);

    # if we are processing confirmation
    if (isset($_GET["AC"]) && ($_GET["AC"] == "Confirmation"))
    {
        # if delete was confirmed
        if (isset($_POST["Submit"]) && ($_POST["Submit"] == "Delete"))
        {
            # hook function to delete feed after HTML is displayed
            $GLOBALS["AF"]->AddPostProcessingCall(function ($Id) {
                        $Feed = new RSSImport_Feed($Id);
                        $Feed->Delete();
            }, $_GET["ID"]);

            # inform user that feed was deleted
            $H_DisplayMode = "FeedDeleted";
        }
        # else if delete was cancelled
        elseif (isset($_POST["Submit"]) && ($_POST["Submit"] == "Cancel"))
        {
            # return to feed list
            $GLOBALS["AF"]->SetJumpToPage("P_RSSImport_ListFeeds");
        }
    }
    # else assume that confirmation is needed
    else
    {
        $H_DisplayMode = "ConfirmationNeeded";
    }
}

