<?PHP
#
#   FILE:  EditUser.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2002-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Edit User Information");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

// @codingStandardsIgnoreStart

# Turn off CodeSniffer for these legacy functions
function PrintCurrentRealName()       {  global $UserToEdit;  print($UserToEdit->Get("RealName"));  }
function PrintCurrentEMail()          {  global $UserToEdit;  print($UserToEdit->Get("EMail"));  }
function PrintCurrentWebSite()        {  global $UserToEdit;  print($UserToEdit->Get("WebSite"));  }
function PrintCurrentAddressLineOne() {  global $UserToEdit;  print($UserToEdit->Get("AddressLineOne"));  }
function PrintCurrentAddressLineTwo() {  global $UserToEdit;  print($UserToEdit->Get("AddressLineTwo"));  }
function PrintCurrentCity()           {  global $UserToEdit;  print($UserToEdit->Get("City"));  }
function PrintCurrentState()          {  global $UserToEdit;  print($UserToEdit->Get("State"));  }
function PrintCurrentZipCode()        {  global $UserToEdit;  print($UserToEdit->Get("ZipCode"));  }
function PrintCurrentCountry()        {  global $UserToEdit;  print($UserToEdit->Get("Country"));  }

function UserFound() {  global $UserWasFound;  return $UserWasFound;  }
function PrintRequestedUserName() {  global $F_UserName;  print($F_UserName);  }

// @codingStandardsIgnoreEnd

/**
* Print 'checked' if the user is disabled.
*/
function PrintUserDisabled()
{
    global $UserToEdit;
    $UserPrivList = $UserToEdit->GetPrivList();
    if (in_array(PRIV_USERDISABLED, $UserPrivList))
    {
        print " checked";
    }
}


/**
* Determine if current user is logged in but lacks sysadmin or
* useradmin privs
*/
function IsEditingOwnAccount()
{
    $User = $GLOBALS["G_User"];

    # user is logged in and is not SYSADMIN or USERADMIN
    if ((!$User->HasPriv(PRIV_SYSADMIN) &&
        !$User->HasPriv(PRIV_USERADMIN)) &&
        $User->IsLoggedIn() == TRUE)
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

/**
* Determine if we're editing ourself.
*/
function AmEditingMyself()
{
    global $UserToEdit;

    # user is logged in and is not SYSADMIN or USERADMIN
    if ($UserToEdit->Get("UserId") == $GLOBALS["G_User"]->Get("UserId"))
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

/**
* Output the option list for user privileges.
*/
function PrintUserPrivOptionList()
{

    global $G_PrivDescriptions, $UserToEdit, $User;

    $UserPrivList = $UserToEdit->GetPrivList();

    # print option list begin
    print("<select name=\"F_Privileges[]\" id=\"F_Privileges[]\"".
        " style=\"width: auto;\" multiple>\n");

    # for each element in list
    $PrivFact = new PrivilegeFactory();
    $Privileges = $PrivFact->GetPrivileges(TRUE, FALSE);
    foreach ( $Privileges as $Id => $Label )
    {
        # disable sys admin or user account admin privileges as a safeguard
        if ($UserToEdit->Get("UserId") == $User->Get("UserId") &&
            $User->HasPriv(PRIV_SYSADMIN) &&
            ($Id == PRIV_SYSADMIN || $Id == PRIV_USERADMIN))
        {
            print "    <option value=\"".$Id."\" disabled=\"disabled\"";
            print ">".htmlspecialchars($Label)."</option>\n";
        }

        # don't display "User Account Disabled" on priv list
        else if ($Id != PRIV_USERDISABLED)
        {
            print("    <option value=\"".$Id."\"");
            if (in_array($Id, $UserPrivList)) {  print(" selected");  }
            print(">".htmlspecialchars($Label)."</option>\n");
        }
    }

    # print option list end
    print("</select>\n");
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
* Load data for a specified user.
* @param string $UserName User to load.
*/
function LoadUser($UserName)
{
    global $UserWasFound;
    global $DB;
    global $User;
    global $UserToEdit;
    global $IdOfUserBeingEdited;
    global $G_PrivDescriptions;

    # if user name looks okay
    if ($User->IsValidUserName($UserName))
    {
        # search for user in database
        $UserToEdit = new CWUser($UserName);

        # if user was found
        if ($UserToEdit->Status() == U_OKAY)
        {
            # set flag indicating user was found with specified name
            $UserWasFound = TRUE;

            # save user ID for use when saving edited values
            $IdOfUserBeingEdited = $UserToEdit->Get("UserId");
            $_SESSION["IdOfUserBeingEdited"] = $IdOfUserBeingEdited;
        }
        else
        {
            # set flag indicating no user found with specified name
            $UserWasFound = FALSE;
        }
    }
    else
    {
        # set flag indicating no user found with specified name
        $UserWasFound = FALSE;
    }
}


# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $F_UserName;
global $IdOfUserBeingEdited;
global $G_PrivDescriptions;
global $UserToEdit;
global $UserWasFound;

# allow user to edit his/her own info
if (IsEditingOwnAccount())
{
    LoadUser($User->Get("UserName"));
}

# check if current user is authorized
else
{
    if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN)) {  return;  }
    if (isset($_POST["F_UserName"]))
    {
        LoadUser($_POST["F_UserName"]);
    }
    # got here from search for user list
    elseif (isset($_GET["F_UserName"]))
    {
        LoadUser($_GET["F_UserName"]);
    }
    elseif (isset($_GET["ID"]))
    {
        $Id = intval($_GET["ID"]);
        $DB = new Database();
        $UserToEdit = new CWUser($Id);
        if ($UserToEdit->Status() == U_OKAY)
        {
            $IdOfUserBeingEdited = $Id;
            $_SESSION["IdOfUserBeingEdited"] = $Id;
            $UserWasFound = TRUE;
        }
        else
        {
            $UserWasFound = FALSE;
        }
    }
    # otherwise we don't have a user to edit and we shouldn't be here
    else
    {
        $UserWasFound = FALSE;
    }
}

if ($UserWasFound)
{
    # remove SYSADMIN and USERADMIN option for non-sysadmin users
    if (!$GLOBALS["G_User"]->HasPriv(PRIV_SYSADMIN))
    {
        unset($G_PrivDescriptions[PRIV_SYSADMIN]);
        unset($G_PrivDescriptions[PRIV_USERADMIN]);
    }

    # remove SYSADMIN option for sysadmin users if editing yourself
    if ($UserToEdit->Get("UserId") == $GLOBALS["G_User"]->Get("UserId") &&
        $GLOBALS["G_User"]->HasPriv(PRIV_SYSADMIN))
    {
        unset($G_PrivDescriptions[PRIV_SYSADMIN]);
    }
}
