<?PHP
#
#   FILE:  ResetPassword.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2006-2015 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("New Account Reset");


# ----- CONFIGURATION  -------------------------------------------------------

# ----- EXPORTED FUNCTIONS ---------------------------------------------------
# (functions intended for use in corresponding HTML file)

# ----- LOCAL FUNCTIONS ------------------------------------------------------
# (functions intended for use only within this file)

# ----- MAIN -----------------------------------------------------------------

$UserName = NULL;
$ResetCode = NULL;

# assume that all checks/actions will fail
$H_UserFound = FALSE;
$H_ResetCodeConfirmed = FALSE;
$H_ManualEntryUsed = FALSE;
$H_PasswordChanged = FALSE;

# retrieve user name and password reset code from URL or form
if (isset($_GET["UN"]) && strlen(trim($_GET["UN"])))
{
    $UserName = $_GET["UN"];
}
elseif (isset($_POST["F_UserName"])
        && strlen(trim($_POST["F_UserName"])))
{
    $UserName = $_POST["F_UserName"];
    $H_ManualEntryUsed = TRUE;
}
if (isset($_GET["RC"]) && strlen(trim($_GET["RC"])))
{
    $ResetCode = $_GET["RC"];
}
elseif (isset($_POST["F_ResetCode"])
        && strlen(trim($_POST["F_ResetCode"])))
{
    $ResetCode = $_POST["F_ResetCode"];
    $H_ManualEntryUsed = TRUE;
}

# if user name and confirmation code found
if (isset($UserName) && isset($ResetCode))
{
    # check user name
    $TargetUser = new SPTUser($UserName);

    # if user name was valid
    if ($TargetUser->Status() == U_OKAY)
    {
        # note that user was found
        $H_UserFound = TRUE;

        # attempt to confirm code
        $H_ResetCodeConfirmed = $TargetUser->IsResetCodeGood($ResetCode);
    }
}

# if new password was available from form
if (isset($_POST["F_Password"])
        && isset($_POST["F_PasswordAgain"])
        && (strlen(trim($_POST["F_Password"]))
                || strlen(trim($_POST["F_PasswordAgain"]))))
{
    # retrieve new password values
    $NewPassword = $_POST["F_Password"];
    $NewPasswordAgain = $_POST["F_PasswordAgain"];

    # if reset code was confirmed
    if ($H_ResetCodeConfirmed)
    {
        # if new passwords entered do not match
        if ($NewPassword != $NewPasswordAgain)
        {
            # set error message
            $H_ErrorMessage = "The two passwords you entered did not match.";
        }
        # else if new password is invalid
        elseif (!CWUser::IsValidPassword($NewPassword,
                 $TargetUser->Get("UserName"), $TargetUser->Get("EMail") ))
        {
            # set error message
            $H_ErrorMessage = "The password you entered was invalid.  "
                            .CWUser::GetPasswordRulesDescription();
        }
        else
        {
            # set new password
            $TargetUser->SetPassword($NewPassword);
            $H_PasswordChanged = TRUE;

            $UserResource = $TargetUser->GetResource();
            $UserResource->Set("Has No Password", FALSE);

            # and make sure that account is activated
            if (!$TargetUser->IsActivated())
            {
                $TargetUser->RevokePriv(PRIV_USERDISABLED);
                $TargetUser->IsActivated(TRUE);

                # signal that user has been activated
                $GLOBALS["AF"]->SignalEvent(
                    "EVENT_USER_VERIFIED",
                    array("UserId" => $TargetUser->Id()));
            }
        }
    }

    # if additional user data was provided
    if (isset($_POST["F_AdditionalData"]))
    {
        # save provided attributes and values
        $UEUI = new UserEditingUI($TargetUser);
        $UEUI->UpdateUserAttributes($_POST);
        $UEUI->UpdateUserFields(CWUser::GetCustomUserFields());
    }
}

# make (safe version of) user name and reset code available for use in HTML
$H_UserName = strip_tags($UserName);
$H_ResetCode = strip_tags($ResetCode);
