<?PHP
#
#   FILE:  EditClassificationComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2001-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
* Delete classifications.
*/
function ConfirmDeleteClassification()
{
    global $ClassId;

    $Class = new Classification($ClassId);

    # first delete all child classes -- USER HAS BEEN WARNED!
    $ChildList = $Class->ChildList();
    foreach ($ChildList as $ChildId)
    {
        $ChildClass = new Classification($ChildId);
        $ChildClass->Delete(FALSE, TRUE, TRUE);
    }
    $Class->Delete(FALSE, TRUE, TRUE);
}

/**
* Save classifications.
*/
function SaveClassification()
{
    global $Class, $_POST, $ErrorMessages;

    $DB = new Database();

    # if new classification segment name is valid
    $F_NewSegmentName = trim($_POST["F_NewSegmentName"]);
    if (isset($_POST["F_QualifierId"]))
    {
        $F_QualifierId = $_POST["F_QualifierId"];
    }
    if (strlen($F_NewSegmentName) > 0)
    {
        # save new classification segment name
        $Class->SegmentName($F_NewSegmentName);

        # save qualifier Id
        if (isset($F_QualifierId))
        {
            $Class->QualifierId(($F_QualifierId == "--") ? 0 : $F_QualifierId);
        }

        # rebuild full classification name
        $Class->RecalcDepthAndFullName();
    }
    else
    {
        # add message to error list
        $ErrorMessages = new ErrorList();
        $ErrorMessages->AddMessage(
        "There was an error with the classification segment name you entered.");
    }
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $Class;
global $ClassId;
global $ErrorMessages;

# check if current user is authorized
if (!CheckAuthorization(PRIV_CLASSADMIN)) {  return;  }

if (isset($_POST["F_ClassificationId"]))
{
    $ClassId = intval($_POST["F_ClassificationId"]);
}

$Submit = $_POST["Submit"];

# pull up existing classification record
$Class = new Classification($ClassId);

# construct jump parameters
$JumpParams =
    ( (isset($_GET["SQ"])) ? ("&SQ=".urlencode($_GET["SQ"])) : "")
    .( (isset($_GET["SL"])) ? ("&SL=".urlencode($_GET["SL"])) : "" )
    .( (isset($_GET["ParentId"])) ? ("&ParentId=".intval($_GET["ParentId"])) : "")
    .( (isset($_GET["FieldId"]))  ? ("&FieldId=".intval($_GET["FieldId"])) : "");

# check for actual deletion
if ($Submit == "Confirm Delete Classification")
{
    ConfirmDeleteClassification();
    $JumpPage="EditClassifications";

    $AF->SetJumpToPage($JumpPage.$JumpParams);
}
elseif ($Submit == "Delete Classification")
{
    $JumpPage="ConfirmDeleteClassification";
    $JumpParams.="&ClassId=".$ClassId;
    $AF->SetJumpToPage($JumpPage.$JumpParams);
}
# else if save changes was requested
elseif ($Submit != "Cancel")
{
    SaveClassification();
    $JumpPage="EditClassifications";
    $AF->SetJumpToPage($JumpPage.$JumpParams);
}
# cancel
elseif ($Submit == "Cancel")
{
    $JumpPage="EditClassifications";
    $AF->SetJumpToPage($JumpPage.$JumpParams);
}

# if errors were found
if (isset($ErrorMessages))
{
    # return to editing page with error messages
    $_SESSION["ErrorMessages"] = $ErrorMessages;
    $AF->SetJumpToPage(
        "EditClassification&ClassificationId=".$ClassId.$JumpParams);
}
