<?PHP

// @codingStandardsIgnoreFile

# legacy globals
global $AF;
global $SysConfig;
global $G_SysConfig;
global $G_PluginManager;
global $DB;
global $User;
global $G_User;
global $Session;


# handle calling of AddJavascript() functions at correct point
global $COMPAT_AddJavascriptHooked;
if (!isset($COMPAT_AddJavascriptHooked))
{
    function COMPAT_CallAddJavascript()
    {
        if (function_exists("AddJavascript"))
        {
            AddJavascript();
        }
    }
    $COMPAT_AddJavascriptHooked = TRUE;
    $GLOBALS["AF"]->HookEvent(
            "EVENT_HTML_FILE_LOAD_COMPLETE", "COMPAT_CallAddJavascript");
}

if (!function_exists("GetActiveUI")) {
function GetActiveUI()
{
    global $G_User;
    global $G_SysConfig;

    # if user is logged in and multiple UIs are allowed or user is sys admin
    if ($G_User->IsLoggedIn() && ($G_SysConfig->AllowMultipleUIsEnabled()
            || $G_User->HasPriv(PRIV_SYSADMIN)))
    {
        # use UI selected by user
        $ActiveUI = $G_User->Get("ActiveUI");

        # is user's UI was null, use default system UI
        if (is_null($ActiveUI))
        {
            $ActiveUI = $G_SysConfig->DefaultActiveUI();
        }
    }
    else
    {
        # use default system UI
        $ActiveUI = $G_SysConfig->DefaultActiveUI();
    }

    # allow local site to override UI choice
    if (LocalFunctionExists("OverrideActiveUI"))
    {
        $ActiveUI = Local_OverrideActiveUI($ActiveUI);
    }

    # correct for old name of default interface
    if ($ActiveUI == "SPTUI--CWIS") {  $ActiveUI = "default";  }

    # return active interface to caller
    return $ActiveUI;
}
}

if (!function_exists("FindUIFile")) {
function FindUIFile($FileName)
{
    # bail out if common HTML requested because ApplicationFramework already loaded it
    if ($FileName == "include/SPT--Common.html") {  return "include/DummyFile.php";  }

    # strip off known prefix and suffix issues
    $FileName = preg_replace(array(
            "/^include\//", "/\.html$/", "/SPT--/"), "", $FileName);

    # ask application framework to find file and return result to caller
    return $GLOBALS["AF"]->GUIFile($FileName);
}
}

if (!function_exists("SoftwareIsCWIS")) {
function SoftwareIsCWIS()
{
    return TRUE;
}
}

if (!function_exists("getmicrotime")) {
function getmicrotime()
{
    return microtime(TRUE);
}
}

if (!function_exists("GetScriptFileName")) {
function GetScriptFileName()
{
    return basename(GetFullScriptFileName());
}
}

if (!function_exists("GetFullScriptFileName")) {
function GetFullScriptFileName()
{
    if (isset($_SERVER["PATH_TRANSLATED"])
             && strlen($_SERVER["PATH_TRANSLATED"]))
    {
        $ScriptFileName = $_SERVER["PATH_TRANSLATED"];
    }
    elseif (isset($_SERVER["SCRIPT_FILENAME"])
             && strlen($_SERVER["SCRIPT_FILENAME"]))
    {
        $ScriptFileName = $_SERVER["SCRIPT_FILENAME"];
    }
    elseif (isset($_SERVER["PATH_INFO"])
             && strlen($_SERVER["PATH_INFO"]))
    {
        $ScriptFileName = $_SERVER["PATH_INFO"];
    }
    else
    {
        exit("ERROR:  unable to determine script file name (GetScriptFileName())");
    }
    return $ScriptFileName;
}
}

if (!function_exists("GetSavedSearchesForUser")) {
function GetSavedSearchesForUser($UserId)
{
    $SSFactory = new SavedSearchFactory();
    return $SSFactory->GetSearchesForUser($UserId);
}
}

if (!function_exists("GetSavedSearchesDueToRun")) {
function GetSavedSearchesDueToRun($UserId)
{
    $SSFactory = new SavedSearchFactory();
    return $SSFactory->GetSearchesDueToRun($UserId);
}
}
