<?PHP
#
#   FILE:  PreviewTopic.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

if (!CheckAuthorization(PRIV_POSTTOFORUMS, PRIV_FORUMADMIN, PRIV_SYSADMIN))
{
    return;
}

/**
* Get value from session.
* @param string $VarName Name of the value to retrieve.
* @return The session value.
*/
function GetFromSession($VarName)
{
    $Value = NULL;
    if (isset($_SESSION[$VarName]))
    {
        $Value = $_SESSION[$VarName];
        unset ($_SESSION[$VarName]);
    }
    return $Value;
}

# ----- MAIN -----------------------------------------------------------------

if (!isset($_GET["FI"]))
{
    $H_ErrorMessages[] = "No ForumId specified";
}

if (!isset($_SESSION["TopicName"]))
{
    $H_ErrorMessages[] = "No TopicName specified";
}

if (!isset($_SESSION["Subject"]))
{
    $H_ErrorMessages[] = "No Subject spcified";
}

if (!isset($_SESSION["Body"]))
{
    $H_ErrorMessages[] = "No Body specified";
}

if (Forum::ItemExists(intval($_GET["FI"])))
{
    $H_Forum = new Forum(intval($_GET["FI"]));
}
else
{
    $H_ErrorMessages[] = "The specified ForumId does not exist.";
}

# If there were errors, just bail:
if (isset($H_ErrorMessages))
{
    return;
}

$H_TopicName = GetFromSession("TopicName");
$H_Subject = GetFromSession("Subject");
$H_Body = GetFromSession("Body");

PageTitle("Preview Message");
