<?PHP
#
#   FILE:  SysAdmin.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("System Administration");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintOaiHarvestLink()
{
    print OurBaseUrl()."index.php?P=OAI";
}

function PrintOaiTestLink()
{
    $OurUrl = OurBaseUrl()."OAI";
    $Link = "http://re.cs.uct.ac.za/cgi-bin/Explorer/2.0-1.46/testoai?"
            ."metadataPrefix=oai_dc&amp;archive=".$OurUrl;
    print $Link;
}

function PrintSupportedFormatNames()
{
    $FormatNames = Image::SupportedFormatNames();
    $count = count($FormatNames);
    foreach ( $FormatNames as $Name )
    {
        print $Name;
        if ( --$count != 0 ) {  print ", ";  }
    }
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------



# ----- MAIN -----------------------------------------------------------------

$UserFactory = new CWUserFactory();
$G_LoggedInUsers = $UserFactory->GetLoggedInUsers();
$G_RecentlyLoggedInUsers = $UserFactory->GetRecentlyLoggedInUsers();

# check if current user is authorized
if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN, PRIV_USERADMIN))
        {  return;  }

$DB = new Database();
$H_ServerVersion = $DB->GetServerVersion(TRUE);
