<?PHP
#
#   FILE:  AddResourceComment.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

require_once("lib/AxisPHP/Axis--StandardLibrary.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_POSTCOMMENTS))
{
    return;
}

# Check preconditions and grab variables that we'll need for later:
if (!isset($_GET["RI"]))
{
    $H_ErrorMessages[]= "No ResourceId Specified";
}
elseif (!Resource::ItemExists($_GET["RI"]))
{
    $H_ErrorMessages[]= "Invalid resource ID specified.";
}
else
{
    $H_Resource = new Resource(intval($_GET["RI"]));
}

if (isset($_GET["MI"]))
{
    $H_MessageId = intval($_GET["MI"]);
    if (!Message::ItemExists($H_MessageId))
    {
        $H_ErrorMessages[]= "Invalid message requested";
    }
    else
    {
        $Message = new Message( $H_MessageId );
        if ($GLOBALS["G_User"]->Id() == $Message->PosterId() ||
            $GLOBALS["G_User"]->HasPriv(PRIV_SYSADMIN) )
        {
            $H_Body = $Message->Body();
        }
        else
        {
            $H_ErrorMessages[]= "You don't have permissions to edit that message";
        }
    }
}
else
{
    if (isset($_SESSION["Body"]))
    {
        $H_Body = $_SESSION["Body"];
        unset ($_SESSION["Body"]);
    }
    else
    {
        $H_Body = "";
    }
}

# If there were errors, bail:
if (isset($H_ErrorMessages))
{
    return;
}

$Schema = new MetadataSchema();
$TitleField = $Schema->GetFieldByMappedName("Title");

if ($H_Resource->UserCanViewField($GLOBALS["G_User"], $TitleField))
{
    $H_Title = $H_Resource->Get($TitleField);
}

if (isset($H_MessageId))
{
    PageTitle("Update Resource Comment");
}
else
{
    PageTitle("Add Resource Comment");
}
