<?PHP

# initialize page generation time clock
$PageGenerationBeginTime = microtime(TRUE);

# define privilege levels for SPT
define("PRIV_SYSADMIN", 1);
define("PRIV_NEWSADMIN", 2);
define("PRIV_RESOURCEADMIN", 3);
define("PRIV_FORUMADMIN", 4);
define("PRIV_CLASSADMIN", 5);
define("PRIV_NAMEADMIN", 6);
define("PRIV_RELEASEADMIN", 7);
define("PRIV_USERADMIN", 8);
define("PRIV_POSTTOFORUMS", 9);
define("PRIV_POSTCOMMENTS", 10);
define("PRIV_USERDISABLED", 11);
define("PRIV_MYRESOURCEADMIN", 12);
define("PRIV_COLLECTIONADMIN", 13);
$PrivDescriptions = array(
        PRIV_SYSADMIN        => "System Administrator",
        PRIV_NEWSADMIN       => "News Administrator",
        PRIV_RESOURCEADMIN   => "Master Resource Administrator",
        PRIV_MYRESOURCEADMIN => "Personal Resource Administrator",
        PRIV_FORUMADMIN      => "Forum Administrator",
        PRIV_CLASSADMIN      => "Classification Administrator",
        PRIV_NAMEADMIN       => "Controlled Name Administrator",
        PRIV_RELEASEADMIN    => "Release Flag Administrator",
        PRIV_USERADMIN       => "User Account Administrator",
        PRIV_COLLECTIONADMIN => "Collection Administrator",
        # following are user permissions, not admin privileges
        PRIV_POSTTOFORUMS    => "Can Post To Forums",
        PRIV_POSTCOMMENTS    => "Can Post Resource Comments",
        PRIV_USERDISABLED    => "User Account Disabled"
        );
$GLOBALS["G_PrivDescriptions"] = $PrivDescriptions;



class ErrorList
{

    # ---- PUBLIC INTERFACE --------------------------------------------------

    /**
    * Object constructor.
    */
    public function __construct()
    {
        $this->Messages = array();
        $this->FormMessages = array();
    }

    /**
    * Add error message to list.
    * @param string $Text Message to add.
    * @param string $FormFieldName Name of form field associated with message.
    */
    public function AddMessage($Text, $FormFieldName = NULL)
    {
        if ($FormFieldName)
        {
            $this->FormMessages[$FormFieldName] = $Text;
        }
        else
        {
            $this->Messages[] = $Text;
        }
    }

    /**
    * Retrieve error messages as an HTML unordered list.
    * @return string HTML code for list.
    */
    public function GetMessagesAsUList()
    {
        $Text = "<ul>\n";
        foreach ($this->Messages as $Message)
        {
            $Text .= sprintf("<li>%s</li>\n", $Message);
        }
        foreach ($this->FormMessages as $Message)
        {
            $Text .= sprintf("<li>%s</li>\n", $Message);
        }
        $Text .= "</ul>\n";

        return $Text;
    }

    /**
    * Check whether there are errors in the list.
    * @return bool TRUE if there are errors, otherwise FALSE.
    */
    public function HasErrors()
    {
        return (count($this->Messages) + count($this->FormMessages))
                ? TRUE : FALSE;
    }

    /**
    * Retrieve any error messages for the specified form field.
    * @param string $FormFieldName Name of field.
    * @return array Error messages.
    */
    public function GetMessageForField($FormFieldName)
    {
        if (isset($this->FormMessages[$FormFieldName]))
        {
            return $this->FormMessages[$FormFieldName];
        }
        else
        {
            return NULL;
        }
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    private $Messages;
    private $FormMessages;
}

# load system, session, and user information
$DB        = new Database();
$SysConfig = new SystemConfiguration($DB);
$G_SysConfig = $SysConfig;
$Session   = new Session($DB);

# create a G_User, typically a CWUser unless the USE_AXIS_USER startup
# option is specified and true
if (isset($GLOBALS["StartUpOpt_USE_AXIS_USER"]) &&
    $GLOBALS["StartUpOpt_USE_AXIS_USER"])
{
    $GLOBALS["G_User"] = new User();
}
else
{
    $GLOBALS["G_User"] = new CWUser();
}
$GLOBALS["User"] = $GLOBALS["G_User"];

# if user is logged in
if ($GLOBALS["G_User"]->IsLoggedIn())
{
    # do not cache page
    $GLOBALS["AF"]->DoNotCacheCurrentPage();
}

# set whether to prefer HTTP_HOST using the system configuration setting
ApplicationFramework::PreferHttpHost($G_SysConfig->PreferHttpHost());

# set the root URL override using the system configuration setting
ApplicationFramework::RootUrlOverride($G_SysConfig->RootUrlOverride());

# initialize mail delivery settings
Email::DeliverySettings($G_SysConfig->Value("EmailDeliverySettings"));
Email::DefaultFrom(trim($GLOBALS["G_SysConfig"]->PortalName())
        ." <".trim($GLOBALS["G_SysConfig"]->AdminEmail()).">");

/**
* Initialize e-mail line ending setting based on system configuration.
* @param object $SysConfig System configuration settings.
*/
function InitializeEmailLineEnding($SysConfig)
{
    $LineEndings = array("CRLF" => "\r\n", "CR" => "\r", "LF" => "\n");
    $LineEndingSetting = $SysConfig->EmailLineEnding();

    # use the setting from the configuration if valid
    if (isset($LineEndings[$LineEndingSetting]))
    {
        Email::LineEnding($LineEndings[$LineEndingSetting]);
    }

    # otherwise default to CRLF
    else
    {
        Email::LineEnding($LineEndings["CRLF"]);
    }
}
InitializeEmailLineEnding($G_SysConfig);

/**
* Make sure all needed temporary directories are available.
*/
function CreateTempDirectories()
{
    $Cwd = getcwd();
    $Directories = array("tmp", "tmp/caches");

    foreach ($Directories as $Dir)
    {
        # the directory must have a forward slash in the beginning since the
        # directory from getcwd() will not have a trailing slash
        $Dir = ($Dir{0} != "/") ? "/".$Dir : $Dir;

        $Dir = $Cwd.$Dir;
        if (!is_dir($Dir) && !file_exists($Dir))
        {
            @mkdir($Dir);
        }
        else if (is_dir($Dir) && !is_writable($Dir))
        {
            @chmod($Dir, "a+w");
        }
    }
}
CreateTempDirectories();

# load software version number
if (file_exists("VERSION"))
{
    $VersionArray = file("VERSION");
}
elseif (file_exists("../VERSION"))
{
    $VersionArray = file("../VERSION");
}
else
{
    $SPT_SoftwareVersion = "--";
    $SPT_SoftwareVersionToDisplay = $SPT_SoftwareVersion;
}
if (!isset($SPT_SoftwareVersion))
{
    $SPT_SoftwareVersion = chop($VersionArray[0]);
    $SPT_SoftwareVersionToDisplay = $SPT_SoftwareVersion;
}
define("CWIS_VERSION", $SPT_SoftwareVersion);

# hook any local periodic maintenance functions
if (LocalFunctionExists("HourlyMaintenance"))
{
    $GLOBALS["AF"]->HookEvent("EVENT_HOURLY", "Local_HourlyMaintenance");
}
if (LocalFunctionExists("DailyMaintenance"))
{
    $GLOBALS["AF"]->HookEvent("EVENT_DAILY", "Local_DailyMaintenance");
}
if (LocalFunctionExists("WeeklyMaintenance"))
{
    $GLOBALS["AF"]->HookEvent("EVENT_WEEKLY", "Local_WeeklyMaintenance");
}


# hook image cache expiration to run hourly
$GLOBALS["AF"]->HookEvent(
    "EVENT_HOURLY", array("SPTImage", "ExpireImageSymlinks") );

# set up search engine and recommender priorities
SPTSearchEngine::SetUpdatePriority(
    $GLOBALS["G_SysConfig"]->SearchEngineUpdatePriority());
SPTRecommender::SetUpdatePriority(
    $GLOBALS["G_SysConfig"]->RecommenderEngineUpdatePriority());

# configure search engine facets
SPTSearchEngine::SetNumResourcesForFacets(
    $GLOBALS["G_SysConfig"]->NumResourcesForSearchFacets());

# configure Vocabulary search path
Vocabulary::FileSearchPaths(array("data/Vocabularies"));

# set up page cache tagging and clearing
$GLOBALS["AF"]->HookEvent("EVENT_FULL_RECORD_VIEW",
        "TagPageCacheForViewingResource");
/**
* Tag the current page in the page cache as being associated with the
* specified resource.
* @param int $ResourceId ID of resource.
*/
function TagPageCacheForViewingResource($ResourceId)
{
    $GLOBALS["AF"]->AddPageCacheTag($ResourceId);
}
$GLOBALS["AF"]->AddPageCacheTag("ResourceList", array(
        "AdvancedSearch",
        ));
$GLOBALS["AF"]->AddPageCacheTag(
        "ResourceList".MetadataSchema::SCHEMAID_DEFAULT, array(
        "Home", "BrowseResources"));
$GLOBALS["AF"]->HookEvent("EVENT_RESOURCE_MODIFY",
        "ClearPageCacheForModifiedResource");
/**
* Clear appropriate entries from page cache when a resource is modified.
* @param object $Resource Resource that was modified.
*/
function ClearPageCacheForModifiedResource($Resource)
{
    $GLOBALS["AF"]->ClearPageCacheForTag($Resource->Id());
    $GLOBALS["AF"]->ClearPageCacheForTag("ResourceList".$Resource->SchemaId());
    $GLOBALS["AF"]->ClearPageCacheForTag("ResourceList");
}

# set up password rules for users
CWUser::SetPasswordRules(
    ($GLOBALS["G_SysConfig"]->PasswordRequiresPunctuation() ?
            CWUser::PW_REQUIRE_PUNCTUATION : 0 ) |
    ($GLOBALS["G_SysConfig"]->PasswordRequiresMixedCase() ?
           CWUser::PW_REQUIRE_MIXEDCASE : 0 ) |
    ($GLOBALS["G_SysConfig"]->PasswordRequiresDigits() ?
           CWUser::PW_REQUIRE_DIGITS : 0 )
);
CWUser::SetPasswordMinLength(
    $GLOBALS["G_SysConfig"]->PasswordMinLength());
CWUser::SetPasswordMinUniqueChars(
    $GLOBALS["G_SysConfig"]->PasswordUniqueChars());

# add known exceptions for JavaScript minimization
$GLOBALS["AF"]->DoNotMinimizeFile(array(
        "ckeditor.js",
        ));
