<?PHP
/**
* Print the blank text field quick search field for the QuickSearch
* JS object
* @param int $FieldId The FieldId for the form element to assign
* @param int $CurrentValue The option's Id value, not for user display
* @param string $CurrentDisplayValue The value to initially populate the field with
* @param boolean $CloneAfter Whether to place a clone after this field
* @param string $FormFieldName Value to use for the input name
*   attribute in the generated html (OPTIONAL, defaults to field name)
*/
function PrintQuickSearchField(
    $FieldId, $CurrentValue, $CurrentDisplayValue,
    $CloneAfter=FALSE, $FormFieldName=NULL)
{
    $GLOBALS["AF"]->RequireUIFile('jquery-ui.css', ApplicationFramework::ORDER_FIRST);
    $GLOBALS["AF"]->RequireUIFile("jquery-ui.js");
    $GLOBALS["AF"]->RequireUIFile("CW-QuickSearch.js");

    $Field = new MetadataField($FieldId);

    if ($FormFieldName === NULL)
    {
        $FormFieldName = "F_".defaulthtmlentities($Field->DBFieldName());
    }

    $SafeFieldId = intval($FieldId);
    $SafeCurrentValue = defaulthtmlentities($CurrentValue);
    $SafeCurrentDisplayValue = defaulthtmlentities($CurrentDisplayValue);
    // @codingStandardsIgnoreStart
?>
   <div class="cw-quicksearch cw-quicksearch-fieldid-<?= $SafeFieldId ?>"
        data-fieldid="<?= $SafeFieldId ?>">
        <textarea class="cw-quicksearch-display cw-resourceeditor-metadatafield
            <?= $FormFieldName; ?> cw-autoresize"><?= $SafeCurrentDisplayValue ?></textarea>
        <input name="<?= $FormFieldName ?>[]"
            class="cw-quicksearch-value" type="hidden" value="<?= $SafeCurrentValue ?>" />
        <div style="display: none;" class='cw-quicksearch-menu'>
            <div class='cw-quicksearch-message ui-front'></div>
        </div>
    </div>
    <?PHP if ($CloneAfter) {?>
    <div class="cw-quicksearch-template cw-quicksearch cw-quicksearch-fieldid-<?= $SafeFieldId; ?>"
         style="display: none;" data-fieldid="<?= $SafeFieldId; ?>">
      <textarea class="cw-quicksearch-display cw-resourceeditor-metadatafield
          <?= $FormFieldName; ?> cw-autoresize"></textarea>
      <input name="<?= $FormFieldName; ?>[]"
          class="cw-quicksearch-value" type="hidden" value="<?= $SafeCurrentValue ?>" />
      <div style="display: none;" class='cw-quicksearch-menu'>
          <div class='cw-quicksearch-message ui-front'></div>
      </div>
    </div>
<?PHP
    }
    // @codingStandardsIgnoreEnd
}
