<?PHP

class ControlledName_Test extends PHPUnit_Framework_TestCase
{
    protected static $TestFieldIds;
    protected static $TestFields;

    /**
    * Prior to running any of the tests, this function is
    * run. It creates all of the test Metadata fields and adds
    * them to class variables $TestFieldIds and $TestFields
    * so each function may use them.
    */
    public static function setUpBeforeClass()
    {
        # construct the schema object
        $Schema = new MetadataSchema(
            MetadataSchema::SCHEMAID_DEFAULT);

        self::$TestFieldIds = array();

        # outline fields to be created
        self::$TestFields = array(
          "ControlledNameTestField" => MetadataSchema::MDFTYPE_TREE,
        );

        # create the fields
        foreach (self::$TestFields as $FieldName => $FieldType)
        {
            $TmpField = $Schema->GetItemByName($FieldName);
            if ($TmpField === NULL)
            {
                $TmpField = $Schema->AddField($FieldName, $FieldType);
            }
            $TmpField->IsTempItem(FALSE);
            self::$TestFieldIds[$FieldName] = $TmpField->Id();
        }

    }

    /**
    * After to running the tests, this function is
    * run. It deletes all of the test Metadata fields.
    */
    public static function tearDownAfterClass()
    {
        # construct the schema object
        $Schema = new MetadataSchema(
            MetadataSchema::SCHEMAID_DEFAULT);
        $Database = new Database();

        # drop all of the test fields
        foreach (self::$TestFieldIds as $FieldName => $FieldId)
        {
            $Schema->DropField($FieldId);

            # remove from OAIFieldMappings too
            $Database->Query("
                DELETE FROM OAIFieldMappings
                WHERE SPTFieldId = " . addslashes($FieldId));
        }
    }


    public function testClassification()
    {
        $MyId = self::$TestFieldIds['ControlledNameTestField'];

        # Create a new name
        $TestName = new ControlledName(
            NULL, "TestName", $MyId);
        $this->assertInstanceOf(
            ControlledName::class, $TestName);
        $this->assertEquals(
            $TestName->FieldId(), $MyId);
        $this->assertEquals(
            $TestName->Name(), "TestName");
        $this->assertEquals(
            $TestName->Status(), ControlledName::STATUS_OK);
        $this->assertEquals(
            $TestName->InUse(), 0);
        $this->assertEquals(
            $TestName->GetAssociatedResources(), array() );

        # look up CNID
        $this->assertEquals(
            array($TestName->Id()),
            ControlledName::SearchForControlledName(
                "TestName", $MyId));

        # Create a duplicate of the name
        $TestDup = new ControlledName(
            NULL, "TestName", $MyId);
        $this->assertEquals(
            $TestDup->Status(), ControlledName::STATUS_EXISTS);
        $this->assertEquals(
            $TestDup->Id(), $TestName->Id() );

        # Create an invalid name
        $TestInv = new ControlledName(-5000);
        $this->assertEquals(
            $TestInv->Status(), ControlledName::STATUS_INVALID_ID);

        # Delete a name
        $TestName->Delete(TRUE);
    }
}
