<?PHP
#
#   FILE:  DeleteTopic.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Delete Topic");

# get parameter or set error message for print (if authorized)
if (!isset($_GET["TI"]) )
{
    $H_ErrorMessages[]= "No TopicId specified";
}
else
{
    if (Topic::ItemExists(intval($_GET["TI"])))
    {
        $H_Topic = new Topic(intval($_GET["TI"]));
        $H_Forum = new Forum($H_Topic->ForumId());

        $ForumOwner = $H_Forum->ModeratorId();
    }
    else
    {
        $H_ErrorMessages[]= "Invalid TopicId specified";
    }
}


# check authorization (sys admin or forum owner)
if (isset($ForumOwner))
{
    if ($GLOBALS["G_User"]->Id() != $ForumOwner && !CheckAuthorization( PRIV_SYSADMIN ))
    {
        DisplayUnauthorizedAccessPage();
        return;
    }
}
else if (!CheckAuthorization( PRIV_SYSADMIN ))
{
    return;
}
