<?PHP
#
#   FILE:  DeleteTopicComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

global $AF;

# get the parameters
if (isset($_POST["F_Submit"]) && isset($_GET["TI"]) &&
    isset($_POST["F_OkayToDelete"]) && Topic::ItemExists($_GET["TI"]))
{
    $Topic = new Topic(intval($_GET["TI"]));
    $ForumModerator = (new Forum($Topic->ForumId()))->ModeratorId();

    # check if current user is authorized
    if ($GLOBALS["G_User"]->Id() != $ForumModerator && !CheckAuthorization(PRIV_SYSADMIN))
    {
        DisplayUnauthorizedAccessPage();
        return;
    }

    # if user is authorized, handle the request:
    $F_Submit = $_POST["F_Submit"];
    if ($F_Submit == "Delete Topic")
    {
        $AF->SetJumpToPage("index.php?P=ForumTopics&FI=".$Topic->ForumId());
        $Topic->Delete();
    }
    else
    {
        $AF->SetJumpToPage("index.php?P=TopicMessages&TI=".$Topic->TopicId());
    }
}
else
{
    DisplayUnauthorizedAccessPage();
    return;
}