<?PHP
#
#   FILE:  EditAboutText.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
* Get the value of the specified session variable. If session variable
*       not found, get the return value of coresponding method of SysConfig.
*       If method not found, "" will be returned.
* Note this method will unset the session variable. So after calling
*       this, you should not access it directly from SESSION but rather keep
*       calling this to get that variable.
* @param string $ValueName Name of the session variable to retrieve or
*       name of the SysConfig method to be called.
* @return string Value of the session variable of return value of
*       the method of SysConfig.
*/
function GetValue($ValueName)
{
    global $SysConfig;
    static $SessionVariables = array();

    $FormFieldName = "F_" . $ValueName;

    if (isset($_SESSION[$FormFieldName]))
    {
        $SessionVariables[$FormFieldName] = $_SESSION[$FormFieldName];
        unset($_SESSION[$FormFieldName]);
    }

    if (isset($SessionVariables[$FormFieldName]))
    {
        $Value = $SessionVariables[$FormFieldName];
    }
    else if (method_exists($SysConfig, $ValueName))
    {
        $Value = $SysConfig->{$ValueName}();
    }
    else
    {
        $Value = "";
    }

    return $Value;
}

# ----- MAIN -----------------------------------------------------------------

PageTitle("Edit About Text");

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

if (isset($_GET["FromSysConfig"]))
{
    $_SESSION["FromSysConfig"] = TRUE;
}

# retrieve error list and prepare for print
if (isset($_SESSION["ErrorMessages"]))
{
    $H_ErrorList = $_SESSION["ErrorMessages"];
    unset($_SESSION["ErrorMessages"]);
}

# prepare about text for print
$H_AboutText = GetValue("AboutText");
