<?PHP
#
#   FILE:  Forums.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# get information forums
$DB = new Database();
$DB->Query("Select * from Forums Order By ForumName");

while ($Entry = $DB->FetchRow())
{
    # ForumId
    if (isset($Entry["ForumId"]))
    {
        $ForumRecord["ForumId"] = $Entry["ForumId"];
        $Forum = new Forum($Entry["ForumId"]);
    }
    else
    {
        continue;
    }

    $ForumRecord["ForumName"] = GetArrayValue($Entry, "ForumName", "(no name set)");
    $ForumRecord["ForumDescription"] = GetArrayValue($Entry, "ForumDescription");
    $ForumRecord["TopicCount"] = is_null($Forum->TopicCount()) ?
            0 : $Forum->TopicCount();
    $ForumRecord["MessageCount"] = is_null($Forum->MessageCount()) ?
            0 : $Forum->MessageCount();
    $ForumRecord["LastMessageDate"] = $Forum->LastMessageDate();
    $ForumRecord["LastMessagePoster"] = $Forum->LastMessagePoster();

    # moderator email
    if ($GLOBALS["G_User"]->IsLoggedIn())
    {
        $ModeratorEmail = $Forum->ModeratorEmail();
        $ModeratorEmail = !is_null($ModeratorEmail) ?
                "(" . MungeEmailAddress($ModeratorEmail) . ")" : NULL;
        $ForumRecord["ModeratorEmail"] = $ModeratorEmail;
    }

    # moderator name
    $Name = $Forum->ModeratorName();
    if (is_null($Name))
    {
        $ModeratorId = is_null($Forum->ModeratorId()) ?
                "NULL" : $Forum->ModeratorId();
        $Name = "No user with ID: ".$ModeratorId." is found.";
    }
    $ForumRecord["ModeratorName"] = $Name;

    # last message poster email
    if ($GLOBALS["G_User"]->IsLoggedIn())
    {
        $LastPosterEmail = $Forum->LastMessagePosterEmail();
        $LastPosterEmail = !is_null($LastPosterEmail) ?
                "(" . MungeEmailAddress($LastPosterEmail) . ")" : NULL;
        $ForumRecord["LastMessagePosterEmail"] = $LastPosterEmail;
    }

    # put forum recod into page variable
    $H_Forums[] = $ForumRecord;
}

PageTitle("Discussion Forums");
