<?PHP
#
#   FILE:  PostMessage.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

require_once("lib/AxisPHP/Axis--StandardLibrary.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Check if current user should have the ability to edit.
* @param Message $Message Message to post.
* @param Forum $Forum Forum of the message.
* @return TRUE if user should have, FALSE otherwise.
*/
function CheckForEdit($Message, $Forum)
{
    global $G_User;

    return $G_User->Id() == $Forum->ModeratorId() ||
        $G_User->Id() == $Message->PosterId() ||
        $G_User->HasPriv(PRIV_SYSADMIN);
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
* Get value from session.
* @param string $VarName Name of the value to retrieve.
* @return The session value.
*/
function GetFromSession($VarName)
{
    $Value = NULL;
    if (isset($_SESSION[$VarName]))
    {
        $Value = $_SESSION[$VarName];
        unset ($_SESSION[$VarName]);
    }
    return $Value;
}

# ----- MAIN -----------------------------------------------------------------

PageTitle("Post Message");

if (!CheckAuthorization(PRIV_POSTTOFORUMS, PRIV_FORUMADMIN, PRIV_SYSADMIN))
{
    return;
}

if (isset($_SESSION["ErrorMessages"]))
{
    $H_ErrorMessages = GetFromSession("ErrorMessages");
}

if (!isset($_GET["TI"]) )
{
    $H_ErrorMessages[]= "No TopicId specified";
    $H_Fatal = TRUE;
    return;
}

if (!Topic::ItemExists(intval($_GET["TI"])))
{
    $H_ErrorMessages[]= "Invalid TopicId specified";
    $H_Fatal = TRUE;
    return;
}
else
{
    $H_Topic = new Topic(intval($_GET["TI"]));
}

$H_Forum = new Forum( $H_Topic->ForumId() );

if (isset($_GET["MI"]))
{
    # Try to extract the quested message, bounce the user if it doesn't exist:
    if (!Message::ItemExists(intval($_GET["MI"])))
    {
        $H_ErrorMessages[]= "Invalid MessageId specified";
        $H_Fatal = TRUE;
        return;
    }
    else
    {
        $H_Message = new Message( intval($_GET["MI"]) );

        $H_Subject = isset($_SESSION["Subject"])
            ? GetFromSession("Subject") : $H_Message->Subject();
        $H_Body = isset($_SESSION["Body"])
            ? GetFromSession("Body") : $H_Message->Body();
    }
}
else
{
    if (isset($_POST["Subject"]))
    {
        $H_Subject = $_POST["F_Subject"];
    }
    elseif (isset($_SESSION["Subject"]))
    {
        $H_Subject = GetFromSession("Subject");
    }
    else
    {
        $H_Subject = "";
    }

    if (isset($_POST["Body"]))
    {
        $H_Body = $_POST["F_Body"];
    }
    elseif (isset($_SESSION["Body"]))
    {
        $H_Body = GetFromSession("Body");
    }
    else
    {
        $H_Body = "";
    }
}

# initialize variables related to the reply to message
$ReplyToId = GetArrayValue($_GET, "ReplyTo");
$H_ReplyTo = NULL;

# if given a reply to message ID and not editing an existing message
if (!is_null($ReplyToId) && !isset($_GET["MI"]))
{
    # check if the message ID is valid
    if (Message::ItemExists($ReplyToId))
    {
        $H_ReplyTo = new Message($ReplyToId);

        # check if the message belongs to this topic
        if ($H_ReplyTo->ParentId() != $H_Topic->TopicId())
        {
            $H_ReplyTo = NULL;
        }
    }

    if (!is_null($H_ReplyTo))
    {
        $H_Subject = $H_ReplyTo->Subject();
    }
}
