<?PHP
#
#   FILE:  ListFeeds.php (RSSImport plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2017 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis
#

# check authorization to see feed list
CheckAuthorization(PRIV_SYSADMIN);

# retrieve sort parameters from URL
$DefaultSortField = "Title";
$SortField = GetFormValue(TransportControlsUI::PNAME_SORTFIELD, $DefaultSortField);
$ReverseSort = GetFormValue(TransportControlsUI::PNAME_REVERSESORT, FALSE);

# convert SortField values into corresponding values for the database
switch ($SortField)
{
    case "Display":
        $SortField = "Enabled";
        break;

    case "Items to Display":
        $SortField = "NumberItemsToDisplay";
        break;

    case "Location":
        $SortField = "DisplayLocations";
        break;

    case "Refresh Rate":
        $SortField = "RefreshRate";
        break;
}

# determine list sort direction
if ($SortField == $DefaultSortField)
{
    $SortAscending = $ReverseSort ? FALSE : TRUE;
}
else
{
    $SortAscending = $ReverseSort ? TRUE : FALSE;
}

# load feed IDs
$FeedFactory = new RSSImport_FeedFactory();
$ItemIds = $FeedFactory->GetItemIds(NULL, FALSE, $SortField, $SortAscending);

# get total number of items
$H_ItemCount = count($ItemIds);

# get where we currently are in list
$H_StartingIndex = GetFormValue(TransportControlsUI::PNAME_STARTINGINDEX, 0);

# calculate ID array checksum and reset paging if list has changed
$H_ListChecksum = md5(serialize($ItemIds));
if ($H_ListChecksum != GetFormValue("CK")) {  $H_StartingIndex = 0;  }

# prune page IDs down to just currently-selected segment
$H_ItemsPerPage = 25;
$ItemIds = array_slice($ItemIds, $H_StartingIndex, $H_ItemsPerPage);

# load items from IDs
$H_Items = array();
foreach ($ItemIds as $Id)
{
    $H_Items[$Id] = new RSSImport_Feed($Id);
}

