<?PHP
#
#   FILE:  Rules_RuleFactory.php  (Rules plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2017 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Factory class for Rule objects for Rules plugin.
*/
class Rules_RuleFactory extends ItemFactory
{
    # ---- PUBLIC INTERFACE --------------------------------------------------

    /**
    * Object constructor.
    */
    public function __construct()
    {
        # set up item factory base class
        parent::__construct("Rules_Rule", "Rules_Rules", "RuleId", "Name");
    }

    /**
    * Retrieve rules that are ready to be checked.
    * @return array Rules (objects) ready to be checked, with rule IDs
    *       for the index.
    */
    public function GetRulesReadyToCheck()
    {
        # retrieve IDs of rules in need of checking
        $CheckTest = "(Enabled = 1) AND ((UNIX_TIMESTAMP(LastChecked)"
                ." + (CheckFrequency * 60)) < UNIX_TIMESTAMP())";
        $this->DB->Query("SELECT RuleId FROM Rules_Rules WHERE ".$CheckTest);
        $RuleIds = $this->DB->FetchColumn("RuleId");

        # instantiate rule objects
        $Rules = array();
        foreach ($RuleIds as $RuleId)
        {
            $Rules[$RuleId] = new Rules_Rule($RuleId);
        }

        # return found rules (if any) to caller
        return $Rules;
    }

    /**
    * Retrieve rules that should be checked when resources change.
    * @return array Rules (objects) to be checked when items change, with rule
    *       IDs for the index.
    */
    public function GetRulesToCheckOnChange()
    {
        # retrieve IDs of rules marked to be checked upon change
        $this->DB->Query("SELECT RuleId FROM Rules_Rules"
                ." WHERE CheckFrequency = ".Rules_Rules::CHECKFREQ_ONCHANGE);
        $RuleIds = $this->DB->FetchColumn("RuleId");

        # instantiate rule objects
        $Rules = array();
        foreach ($RuleIds as $RuleId)
        {
            $Rules[$RuleId] = new Rules_Rule($RuleId);
        }

        # return found rules (if any) to caller
        return $Rules;
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------
}
