<?PHP
#
#   FILE:  ConfigureActionsComplete.php
#
#   Copyright 2014 Internet Scout Project
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

$MyPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("UrlChecker");

# configuration for URL Checker Actions
$Schemas = array();
foreach ($MyPlugin->ConfigSetting("FieldsToCheck") as $FieldId)
{
    $Field = new MetadataField($FieldId);
    $SCId = $Field->SchemaId();

    $Schemas[$SCId] = new MetadataSchema($SCId);
}

$Actions = array("Release", "Withhold", "Autofix");
foreach ($Actions as $Action)
{
    $Configuration = array();
    foreach ($Schemas as $SchemaId => $Schema)
    {
        $FEUI = new FieldEditingUI($Action."_".$SchemaId, $SchemaId);
        $Configuration[$SchemaId] = $FEUI->GetValuesFromFormData();
    }
    $MyPlugin->ConfigSetting($Action."Configuration", $Configuration);
}

$GLOBALS["AF"]->SetJumpToPage("P_UrlChecker_ConfigureActions");
