<?PHP
#
#   FILE:  ViewMessage.php (Mailer plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2017 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis
#

# check that user should be on this page
CheckAuthorization(PRIV_COLLECTIONADMIN, PRIV_SYSADMIN);

$H_Errors = [];

if (!isset($_GET["ID"]) || !isset($_GET["A"]))
{
    $H_Errors[]= "Required parameters not specified.";
    return;
}

# pull out the provided action
$Action = $_GET["A"];

if (!in_array($Action, ["View", "Send", "Delete"]))
{
    $H_Errors[]= "Invalid action.";
    return;
}

$ItemId = intval($_GET["ID"]);
if (!Mailer_StoredEmail::ItemExists($ItemId))
{
    $H_Errors[]= "Invalid stored message Id.";
    return;
}

$H_StoredEmail = new Mailer_StoredEmail($ItemId);

if ($Action == "Send")
{
    $H_StoredEmail->Send();
    $GLOBALS["AF"]->SetJumpToPage(
        "index.php?P=P_Mailer_ListQueuedEmail");
    return;
}
elseif ($Action == "Delete")
{
    $H_StoredEmail->Destroy();
    $GLOBALS["AF"]->SetJumpToPage(
        "index.php?P=P_Mailer_ListQueuedEmail");
    return;
}
