<?PHP

/**
* Print the data classes necessary for the buttons to pass urls/attributes to the JS
* @param string $ButtonStyleClasses the classes applied to all add/remove buttons
* @param string $RemoveActionUrl the URL to complete the remove action.
* @param string $AddActionUrl the URL to complete the add action.
* @param int $FolderId the ID of the currently active folder.
* @param int $ResourceId the ID of the resource for which we are generating the button.
*/
function Folders_PrintFolderButtonAttributes($ButtonStyleClasses, $RemoveActionUrl,
          $AddActionUrl, $FolderId, $ResourceId)
{
  return   'id="cw-folders-action'. defaulthtmlentities($ResourceId) . '"' .
           ' data-buttonclasses="' . $ButtonStyleClasses . '"' .
           ' data-addurl="'. defaulthtmlentities($AddActionUrl) . '"' .
           ' data-removeurl='. defaulthtmlentities($RemoveActionUrl) . '"' .
           ' data-plusurl= "'. ApplicationFramework::BaseUrl() . $GLOBALS["AF"]->GUIFile("folder_add.png") . '"' .
           ' data-xurl= "'. ApplicationFramework::BaseUrl() . $GLOBALS["AF"]->GUIFile("cross.png") . '"' .
           ' data-parentfolderid="'. defaulthtmlentities($FolderId) . '" ' .
           ' data-itemid="'. defaulthtmlentities($ResourceId) .'"';
}

/**
* Display the 'Add to or Remove from Current Folder' button for a given resource.
* @param boolean $InFolder whether the resource is in the currently selected folder.
* @param string $AddActionUrl the URL to complete the add action.
* @param string $RemoveActionUrl the URL to complete the remove action.
* @param int $FolderId the ID of the currently active folder.
* @param int $ResourceId the ID of the resource for which we are generating the button.
* @param string $Location the insertion location of the button -- clases depend on this.
*/
function Folders_InsertButtonHTML($InFolder, $AddActionUrl, $RemoveActionUrl,
        $FolderId, $ResourceId, $Location)
{
    $ButtonStyleClasses = "cw-button cw-button-elegant cw-button-iconed ";
    if($Location == "Resource Summary Buttons")
    {
      $ButtonStyleClasses .= " cw-button-constrained ";
    }
    ?>

    <!-- BEGIN FOLDER BUTTON DISPLAY -->
    <?PHP
    if($InFolder)
      {
      // @codingStandardsIgnoreStart
      ?>

      <a class="<?PHP print $ButtonStyleClasses;?> cw-folders-removeresource"
         title="Remove this resource from the currently selected folder"
         href="<?PHP print defaulthtmlentities($RemoveActionUrl); ?>"
         <?PHP print
          Folders_PrintFolderButtonAttributes($ButtonStyleClasses, $RemoveActionUrl,
                    $AddActionUrl, $FolderId, $ResourceId);?>>
        <img class="cw-button-icon" src="<?PHP $GLOBALS["AF"]->PUIFile("cross.png"); ?>" alt="" />
        Folder
      </a>

<?PHP
    }
    else
    { ?>
      <a class="<?PHP print $ButtonStyleClasses;?> cw-folders-addresource"
         title="Add this resource to the currently selected folder "
         href="<?PHP print defaulthtmlentities($AddActionUrl); ?>"
         <?PHP print
          Folders_PrintFolderButtonAttributes($ButtonStyleClasses, $RemoveActionUrl,
                    $AddActionUrl, $FolderId, $ResourceId);?>>
        <img class="cw-button-icon"
             src="<?PHP $GLOBALS["AF"]->PUIFile("folder_add.png"); ?>" alt="" />
        Folder
      </a>

  <?PHP
    // @codingStandardsIgnoreEnd
    }?>
    <!-- END FOLDER BUTTON DISPLAY -->
  <?PHP
}
