<?PHP
#
#   FILE:  RegisterPortal.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Register Portal");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Print the list that previews all the information sent by a registration.
*/
function PrintRegistrationInfo()
{
    global $G_SysConfig;
    global $SPT_SoftwareVersionToDisplay;

    # general site info
    print("Software: CWIS ".$SPT_SoftwareVersionToDisplay."<br>\n");
    print("Site Name: <i>".$G_SysConfig->PortalName()."</i><br>\n");
    print("Site URI: <i>".$_SERVER["SERVER_NAME"]
          .dirname($_SERVER["REQUEST_URI"])."</i><br>\n");
    print("Admin E-Mail: <i>".$G_SysConfig->AdminEmail()."</i><br>\n");

    # configuration settings
    print("Default UI: ".$G_SysConfig->DefaultActiveUI()."<br>\n");
    print("Current Theme: ".$G_SysConfig->CurrentTheme()."<br>\n");
    print("Forums: ".($G_SysConfig->ForumsEnabled() ?
            "ENABLED" : "DISABLED")."<br>\n");
    print("Announcements: ".($G_SysConfig->AnnouncementsEnabled() ?
            "ENABLED" : "DISABLED")."<br>\n");
    print("Multiple UIs: ".($G_SysConfig->AllowMultipleUIsEnabled() ?
            "ENABLED" : "DISABLED")."<br>\n");
    print("Ratings: ".($G_SysConfig->ResourceRatingsEnabled() ?
            "ENABLED" : "DISABLED")."<br>\n");
    print("Comments: ".($G_SysConfig->ResourceCommentsEnabled() ?
            "ENABLED" : "DISABLED")."<br>\n");
    print("Search Update: ".($G_SysConfig->SearchDBEnabled() ?
            "ENABLED" : "DISABLED")."<br>\n");
    print("Recommender Update: ".($G_SysConfig->RecommenderDBEnabled() ?
            "ENABLED" : "DISABLED")."<br>\n");
    print("Search Logic: ".($G_SysConfig->SearchTermsRequired() ?
            "AND" : "OR")."<br>\n");

    # resources info
    $RFactory = new ResourceFactory();
    $ResourceCount = $RFactory->GetItemCount();

    print("Resource Count: ".$ResourceCount."<br>\n");
    $ReleasedResourceCount = count(
        $RFactory->FilterNonViewableResources(
            $RFactory->GetItemIds(), CWUser::GetAnonymousUser()));

    print("Released Count: ".$ReleasedResourceCount."<br>\n");
    $RatedResourceCount = $RFactory->GetRatedResourceCount();
    print("Rating Count: ".$RatedResourceCount."<br>\n");

    $ClassFactory = new ClassificationFactory();
    $ClassCount = $ClassFactory->GetItemCount();
    print("Classification Count: ".$ClassCount."<br>\n");

    $SampleCount = $RFactory->GetItemCount(
        "INSTR(Description, '[--SAMPLE RECORD--]') > 0");
    print("Sample Count: ".$SampleCount."<br>\n");

    $SearchEngine = new SPTSearchEngine();
    $TermCount = $SearchEngine->SearchTermCount();
    print("Search Term Count: ".$TermCount."<br>\n");

    # PHP configuration
    print("PHP Version: ".phpversion()."<br>\n");
    $Settings = array(
            "safe_mode",
            "register_globals",
            "max_execution_time",
            "memory_limit",
            "post_max_size",
            "file_uploads",
            "upload_max_filesize",
            );
    foreach ($Settings as $Setting)
    {
        $Value = ini_get($Setting);
        if (!strlen($Value)) {  $Value = "Off";  }
        if ($Value == "1") {  $Value = "On";  }
        print("PHP ".$Setting.": ".$Value."<br>\n");
    }
    $PhpInfo = GetPhpInfo();
    $Val = isset($PhpInfo["gd"]["GD Version"][0])
            ? $PhpInfo["gd"]["GD Version"][0] : "unavailable";
    print("PHP GD version: ".$Val."<br>\n");
    $Val = (isset($PhpInfo["gd"]["PNG Support"][0]))
            ? $PhpInfo["gd"]["PNG Support"][0] : "unavailable";
    print("PHP GD PNG Support: ".$Val."<br>\n");
    $Val = (isset($PhpInfo["gd"]["JPG Support"][0]))
            ? $PhpInfo["gd"]["JPG Support"][0] : "unavailable";
    print("PHP GD JPG Support: ".$Val."<br>\n");
    $Val = (isset($PhpInfo["gd"]["GIF Support"][0]))
            ? $PhpInfo["gd"]["GIF Support"][0] : "unavailable";
    print("PHP GD GIF Support: ".$Val."<br>\n");

    $DB = new Database();

    # operating environment
    print("MySQL Client Version: ".$DB->GetClientVersion()."<br>\n");
    print("MySQL Server Version: ".$DB->GetServerVersion()."<br>\n");
    print("MySQL Connection Type: ".$DB->GetHostInfo()."<br>\n");
    print("HTTP Server: <i>".$_SERVER["SERVER_SOFTWARE"]."</i><br>\n");
    print("OS Stamp: <i>".$PhpInfo[""]["System"][0]."</i><br>\n");
}

// @codingStandardsIgnoreStart

# print current content of user-entered registration settings
function PrintContactName()
{
    print($GLOBALS["G_SysConfig"]->ContactName());
}

function PrintContactEmail()
{
    print($GLOBALS["G_SysConfig"]->ContactEmail());
}

function PrintOrganization()
{
    print($GLOBALS["G_SysConfig"]->Organization());
}

function PrintOrganizationType()
{
    print($GLOBALS["G_SysConfig"]->OrganizationType());
}

function PrintSiteType()
{
    print($GLOBALS["G_SysConfig"]->SiteType());
}

function PrintOkayToListSite()
{
    print($GLOBALS["G_SysConfig"]->OkayToListSite());
}

function PrintCheckedIfOrganizationTypeIs($OrganizationType)
{
    print(($GLOBALS["G_SysConfig"]->OrganizationType() == $OrganizationType) ? " checked" : "");
}

function PrintCheckedIfSiteTypeIs($SiteType)
{
    print(($GLOBALS["G_SysConfig"]->SiteType() == $SiteType) ? " checked" : "");
}

function PrintCheckedIfOkayToListSite()
{
    print(($GLOBALS["G_SysConfig"]->OkayToListSite()) ? " checked" : "");
}

// @codingStandardsIgnoreEnd

# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $SPT_SoftwareVersionToDisplay;

if (!CheckAuthorization( PRIV_SYSADMIN )) {
    return;
}
