<?PHP
#
#   FILE:  SendMany.php (Mailer plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2017 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis
#

# check that user should be on this page
CheckAuthorization(PRIV_COLLECTIONADMIN, PRIV_SYSADMIN);

$H_Errors = [];

# make sure MessageIds were provided
if (!isset($_GET["IDs"]))
{
    $H_Errors[]= "Required parameters not specified.";
    return;
}

# extract MessageIds, check them all for validity
$IDs = explode("-", $_GET["IDs"]);
foreach ($IDs as $Id)
{
    if (!Mailer_StoredEmail::ItemExists($Id))
    {
        $H_Errors[]= "Invalid stored message Id: ".$Id.".";
    }
}

# if any Ids were invalid, bail
if (count($H_Errors))
{
    return;
}

# otherwise, iterate over all the provided IDs and send them all
foreach ($IDs as $Id)
{
    $StoredEmail = new Mailer_StoredEmail($Id);
    $StoredEmail->Send();
}

# and then bounce to the mail queue
$GLOBALS["AF"]->SetJumpToPage(
    "index.php?P=P_Mailer_ListQueuedEmail");
