<?PHP
#
#   FILE:  EditControlledNameComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2017 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

if (!CheckAuthorization(PRIV_NAMEADMIN)) {  return;  }

$Submit = GetArrayValue($_POST, "Submit");
$SchemaId = GetArrayValue($_GET, "SC");

if ($Submit == "Cancel")
{
    $SC = $SchemaId ? "&SC=".intval($SchemaId) : "";
    $GLOBALS["AF"]->SetJumpToPage("EditControlledName".$SC);
    return;
}

$H_ModifiedCNames = [];
$H_DeletedCNames = [];
$H_ModifiedResources = [];

# check for actual deletion
if ($Submit == "Save Changes")
{
    $AffectedResourceIds = [];

    # iterate over the controlled names in our form
    // @codingStandardsIgnoreStart
    for ($i = 0; array_key_exists('F_ControlledNameId_'.$i, $_POST); $i++)
    {
        // @codingStandardsIgnoreEnd
        $ControlledNameId = GetArrayValue($_POST, 'F_ControlledNameId_'.$i);
        $ControlledName = trim(GetArrayValue($_POST, 'F_ControlledName_'.$i));
        $QualifierId = GetArrayValue($_POST, 'F_QualifierName_'.$i);
        $VariantName = GetArrayValue($_POST, 'F_VariantName_'.$i);
        $Remap = array_filter(GetArrayValue($_POST, 'D_Remap_'.$i, []));
        $Delete = GetArrayValue($_POST, 'F_Delete_'.$i, FALSE);

        # if "--" selected, set qualifier id = NULL
        if ($QualifierId == "--")
        {
            $QualifierId = NULL;
        }

        # update the values for each controlled name
        if (!empty($ControlledName))
        {
            # pull out specified CName
            $CN = new ControlledName($ControlledNameId);

            if ($Delete)
            {
                # handle CName deletion
                $H_DeletedCNames[$CN->Name()] = $CN->VariantName();

                $AffectedResourceIds = array_merge(
                    $AffectedResourceIds, $CN->GetAssociatedResources() );

                $CN->Delete();
            }
            else
            {
                # start off assuming no changes
                $Modified = FALSE;

                # if the user requested a remap
                if (count($Remap) > 0)
                {
                    # pull out the Id of the target cname
                    $OtherId = reset($Remap);

                    # if the id is valid, perform a remapping
                    $CNFact = new ControlledNameFactory($CN->FieldId());
                    if ($CNFact->ItemExists($OtherId))
                    {
                        # perform the remapping
                        $GLOBALS["AF"]->SignalEvent(
                            "EVENT_CNAME_REMAPPED", array($CN->Id(), $OtherId));
                        $CN->RemapTo($OtherId);

                        $Modified = TRUE;
                    }
                }
                else
                {
                    # handle name changes
                    if ($CN->Name() != $ControlledName)
                    {
                        $Modified = TRUE;
                        $CN->Name($ControlledName);
                    }

                    # handle qualifier changes
                    if (!empty($QualifierId))
                    {
                        if ($CN->QualifierId != $QualifierId)
                        {
                            $Modified = TRUE;
                            $CN->QualifierId($QualifierId);
                        }
                    }

                    # handle variant changes
                    if ($CN->VariantName() != $VariantName)
                    {
                        $Modified = TRUE;
                        $CN->VariantName($VariantName);
                    }
                }

                # if this CName was modified, add it to our list of changed names
                # and gather its list of ResourceIds.
                if ($Modified)
                {
                    $H_ModifiedCNames[$CN->Name()] = $CN->VariantName();
                    $AffectedResourceIds = array_merge(
                        $AffectedResourceIds, $CN->GetAssociatedResources() );
                }
            }
        }
    }

    # iterate over all the affected resources, handle their
    # autoupdated fields, and queue search engine updates
    $AffectedResourceIds = array_unique($AffectedResourceIds);
    foreach ($AffectedResourceIds as $ResourceId)
    {
        $Resource = new Resource($ResourceId);
        $Resource->UpdateAutoupdateFields(
            MetadataField::UPDATEMETHOD_ONRECORDCHANGE,
            $GLOBALS["G_User"]);

        # update search and recommender DBs if configured to do so
        $Resource->QueueSearchAndRecommenderUpdate();

        # signal the modified event
        $GLOBALS["AF"]->SignalEvent("EVENT_RESOURCE_MODIFY",
            array("Resource" => $Resource));

        $H_ModifiedResources[]=
            "<a href=\"index.php?P=FullRecord&amp;ID=".
            $Resource->Id()."\" target=\"_blank\">".
            $Resource->GetMapped("Title")."</a><br>";
    }
}

PageTitle("Edit Controlled Name Complete");
