<?PHP
#
#   FILE:  Subscribe.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

# make sure our plugin is enabled, bounce to Home if not
if (!$GLOBALS["G_PluginManager"]->PluginEnabled("MailingList"))
{
    $GLOBALS["AF"]->SetJumpToPage("Home");
    return;
}

$Jump = GetArrayValue($_GET, "ReturnTo", "Preferences");
$H_List = GetArrayValue($_GET, "List", NULL);

if ($GLOBALS["G_User"]->IsLoggedIn())
{
    $GLOBALS["AF"]->SuppressHTMLOutput();

    if ($H_List !== NULL)
    {
        $MyPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("MailingList");
        $MyPlugin->Subscribe( $GLOBALS["G_User"], $H_List );
    }

    $GLOBALS["AF"]->SetJumpToPage($Jump);
}
else
{
    $EmailAddr = isset($_GET["F_EMail"]) ?
               $_GET["F_EMail"] : "";

    # modify the DUPLICATEEMAIL error message to be more clear about how
    # subscriptions are edited for existing accounts

    $AdditionalErrorMessages[U_DUPLICATEEMAIL]
        = "The email address you entered is already associated"
        ." with an account. To manage subscription settings for"
        ." an existing account, you must log in and access your Preferences."
        ." If you have forgotten the account user name or"
        ." password you can click"
        ." <a href=\"index.php?P=ForgottenPasswordComplete&UN="
        .urlencode($EmailAddr)."\">here</a>"
        ." to send a reminder via email." ;

    $AdditionalErrorMessages =
        $GLOBALS["AF"]->SignalEvent(
            "EVENT_USER_SIGNUP_EXTEND_ERROR_LIST",
                array($AdditionalErrorMessages));

    $H_FormUI = new FormUI(MailingList::GetSubscriptionFormFields($H_List), array());
    $H_SubscribedSuccessfully = FALSE;

    if (isset($_POST["Submit"]))
    {
        # don't allow new user signups from spambots
        if ($GLOBALS["G_PluginManager"]->PluginEnabled("BotDetector") &&
            $GLOBALS["G_PluginManager"]->GetPlugin("BotDetector")->CheckForSpamBot())
        {
            $GLOBALS["AF"]->SetJumpToPage("UnauthorizedAccess");
            return;
        }

        # make sure mailing list to be subscribed to is valid
        $MyPlugin = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();
        if ($H_List === "")
        {
            $H_FormUI->LogError("No mailing list provided.");
        }
        else if (!in_array($H_List, $MyPlugin->GetAllLists()))
        {
            $H_FormUI->LogError("No such mailing list.");
        }

        # generate a username and stuff it into $_POST
        #   (if the EMail and EmailAgain don't match, we'll
        #    catch that error in the next block)
        $_POST["F_UserName"] =
            CWUserFactory::GenerateUniqueUsernameFromEmail(
            $_POST["F_EMail"]);

        # generate a random initial password
        $Password = GetRandomCharacters(8);
        $_POST["F_Password"] = $Password;
        $_POST["F_PasswordAgain"] = $Password;

        # check and handle errors in the incoming values
        $UserErrorCodes = UserEditingUI::TestUserValues($_POST);
        if (UserEditingUI::UserFormHasErrors(
                $H_FormUI, $UserErrorCodes, $AdditionalErrorMessages[0]))
        {
            return;
        }

        # attempt to create the new user
        $UserFactory = new CWUserFactory();
        $NewUser = $UserFactory->CreateNewUser($_POST["F_UserName"],
                    $_POST["F_Password"], $_POST["F_PasswordAgain"],
                    $_POST["F_EMail"], $_POST["F_EMailAgain"]);

        # if user creation failed
        if (!is_object($NewUser) || ($NewUser->Status() != U_OKAY))
        {
            # log errors
            foreach ($NewUser as $ErrorCode)
            {
                $H_FormUI->LogError($ErrorCode);
            }
            return;
        }

        # convert message substitutions into the format that Mailer expects
        $Substitutions = array();
        foreach (UserEditingUI::GetActivationEmailSubstitutions($NewUser)
                 as $Key => $Val)
        {
            $Key = preg_replace("/X-([A-Z]+)-X/", "$1", $Key);
            $Substitutions[$Key] = $Val;
        }
        $Substitutions["ACTIVATIONCODE"] = $NewUser->GetActivationCode();

        # and use Mailer to send the message
        $Mailer = $GLOBALS["G_PluginManager"]->GetPlugin("Mailer");
        $TemplateId = $MyPlugin->ConfigSetting("SubscriptionConfirmationTemplate");
        $Mailer->SendEmail(
            $TemplateId,
            $NewUser,
            NULL,
            $Substitutions );

        # save user attributes provided:
        $UEUI = new UserEditingUI($NewUser);
        $UEUI->UpdateUserAttributes($_POST, TRUE);

        # always disable account until activated via confirmation e-mail
        $NewUser->GivePriv(PRIV_USERDISABLED);

        # signal that user has been added
        $AF->SignalEvent("EVENT_USER_ADDED", array(
                "UserId" => $NewUser->Id(), "Password" => $_POST["F_Password"]));

        # set e-mail address and user name for use in page display
        $H_EMailAddress = User::NormalizeEMailAddress($_POST["F_EMail"]);
        $H_UserName = User::NormalizeUserName($_POST["F_UserName"]);

        # edit the user to subscribe them to the given list
        # these subscriptions won't be synced over to the backend until after
        # the user verifies their account

        $Schema = new MetadataSchema(MetadataSchema::SCHEMAID_USER);
        $MLSubsField = $Schema->GetFieldByName("Mailing List Subscriptions");
        $CNFactory = new ControlledNameFactory( $MLSubsField->Id() );

        $CNameId = $CNFactory->GetItemIdByName($H_List);

        $UserResource = $NewUser->GetResource();
        $UserResource->Set( $MLSubsField, $CNameId );

        # here, mark the user as needing a password entry
        $UserResource->Set("Has No Password", TRUE);

        $H_SubscribedSuccessfully = TRUE;
    }
}
