<?PHP
#
#   FILE:  CleanSpam.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Print all the resource comments made by the target user
* @param CWUser $TgtUser The user whose comments we want to print
*/
function PrintResourceComments($TgtUser)
{
    $MessageFactory = new MessageFactory();
    $Comments = $MessageFactory->GetMessagesPostedByUser($TgtUser->Id());

    foreach ($Comments as $Comment)
    {
        PrintForumMessage($Comment, FALSE, NULL, NULL, NULL, TRUE, NULL);
    }
}

# ----- MAIN -----------------------------------------------------------------

PageTitle("Moderate Spam");

global $AF;

# check if current user is authorized
if (!CheckAuthorization(PRIV_FORUMADMIN, PRIV_USERADMIN))
{
    return;
}

if (!isset($_GET["PI"]))
{
    $H_ErrorMessages[]= "No PosterId Specified";
}

if (!isset($_GET["RI"]) && !isset($_GET["TI"]) )
{
    $H_ErrorMessages[]= "Neither ResourceId nor TopicId is specified";
}

# Don't try to extract further information if we didn't get the required parameters.
if (isset($H_ErrorMessages))
{
    return;
}

$H_TgtUser = new CWUser( intval($_GET["PI"]) );
if (isset($_GET["RI"]))
{
    $H_ResourceId = intval($_GET["RI"]);
}
else
{
    $H_TopicId = intval($_GET["TI"]);
}
