<?PHP
#
#   FILE:  ExportUsers.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

PageTitle("Export Users");

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN);

# if user clicked away while doing export, these variales would not get unset
foreach (array("FileName", "UserCount", "ExportPath") as $Val)
{
    if (isset($_SESSION[$Val]))
    {
        unset($_SESSION[$Val]);
    }
}

$PFactory = new PrivilegeFactory();
$FormFields = array(
    "UserPrivs" => array(
        "Type" => FormUI::FTYPE_OPTION,
        "Label" => "User Privileges",
        "AllowMultiple" => TRUE,
        "Rows" => 15,
        "Options" => $PFactory->GetPrivileges(TRUE, FALSE),
        "Help" => "Determines the users that will be exported based on "
        ."assigned privileges. <b>To export all users, select none.</b>"
    ),
);

$H_Form = new FormUI($FormFields);
