<?PHP

/**
* Display User's Saved Searches Sidebar HTML -- called by MySearchesPlugin
* @param array $Searches array of search arrays to display; Each search array
* contains a string SearchURL which is the URL to reach the search, a string SearchTitle
* for use in the title filed of the a tag linking to the seach and a SearchName for use
* in the a tag for linking to the search.
* @return Returns the User's Saved Searches HTML as a string.
*/
function PrintMySearchesSidebarBlock($Searches)
{
?>
  <!-- BEGIN MY SEARCHES DISPLAY -->
  <div class="cw-section cw-section-simple cw-html5-section">
      <div class="cw-section-header cw-html5-header">
          <strong>My Searches</strong>
          <a class="cw-button cw-button-constrained cw-button-elegant" href="index.php?P=ListSavedSearches">Manage</a>
      </div>
      <div class="cw-section-body">
          <ul class="cw-list cw-list-noindent cw-list-dotlist">
              <?PHP foreach ($Searches as $Search) { ?>
              <li><a href="<?PHP  print $Search["SearchURL"];  ?>" title="Search Parameters:
                                                                  <?PHP  print "\n".htmlspecialchars($Search["SearchTitle"]);  ?>">
                  <?PHP print $Search["SearchName"];  ?></a>
              </li>
              <?PHP } ?>
          </ul>
      </div>
  </div>
  <!-- END MY SEARCHES DISPLAY -->
<?PHP
}
